/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ManagementEvent;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.managementgraph.ManagementVertexID;
import org.apache.flink.runtime.util.EnumUtils;

public final class ExecutionStateChangeEvent
extends AbstractEvent
implements ManagementEvent {
    private ManagementVertexID managementVertexID;
    private ExecutionState newExecutionState;

    public ExecutionStateChangeEvent(long timestamp, ManagementVertexID managementVertexID, ExecutionState newExecutionState) {
        super(timestamp);
        this.managementVertexID = managementVertexID;
        this.newExecutionState = newExecutionState;
    }

    public ExecutionStateChangeEvent() {
        this.managementVertexID = new ManagementVertexID();
        this.newExecutionState = ExecutionState.CREATED;
    }

    public ManagementVertexID getVertexID() {
        return this.managementVertexID;
    }

    public ExecutionState getNewExecutionState() {
        return this.newExecutionState;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.managementVertexID.read(in);
        this.newExecutionState = EnumUtils.readEnum((DataInput)in, ExecutionState.class);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.managementVertexID.write(out);
        EnumUtils.writeEnum((DataOutput)out, this.newExecutionState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExecutionStateChangeEvent)) {
            return false;
        }
        ExecutionStateChangeEvent stateChangeEvent = (ExecutionStateChangeEvent)obj;
        if (!stateChangeEvent.getNewExecutionState().equals((Object)this.newExecutionState)) {
            return false;
        }
        return stateChangeEvent.getVertexID().equals(this.managementVertexID);
    }

    @Override
    public int hashCode() {
        if (this.newExecutionState != null) {
            return this.newExecutionState.hashCode();
        }
        if (this.managementVertexID != null) {
            return this.managementVertexID.hashCode();
        }
        return super.hashCode();
    }
}

