/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.channels.ChannelID;

public final class ChannelDeploymentDescriptor
implements IOReadableWritable {
    private final ChannelID outputChannelID;
    private final ChannelID inputChannelID;

    public ChannelDeploymentDescriptor(ChannelID outputChannelID, ChannelID inputChannelID) {
        if (outputChannelID == null) {
            throw new IllegalArgumentException("Argument outputChannelID must not be null");
        }
        if (inputChannelID == null) {
            throw new IllegalArgumentException("Argument inputChannelID must not be null");
        }
        this.outputChannelID = outputChannelID;
        this.inputChannelID = inputChannelID;
    }

    public ChannelDeploymentDescriptor() {
        this.outputChannelID = new ChannelID();
        this.inputChannelID = new ChannelID();
    }

    public void write(DataOutputView out) throws IOException {
        this.outputChannelID.write(out);
        this.inputChannelID.write(out);
    }

    public void read(DataInputView in) throws IOException {
        this.outputChannelID.read(in);
        this.inputChannelID.read(in);
    }

    public ChannelID getOutputChannelID() {
        return this.outputChannelID;
    }

    public ChannelID getInputChannelID() {
        return this.inputChannelID;
    }
}

