/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.topology;

import java.util.Iterator;
import java.util.Stack;
import org.apache.flink.runtime.topology.NetworkNode;
import org.apache.flink.runtime.topology.NetworkTopology;

public class NetworkTopologyIterator
implements Iterator<NetworkNode> {
    private Stack<TraversalEntry> traversalStack = new Stack();

    NetworkTopologyIterator(NetworkTopology networkTopology) {
        this.traversalStack.add(new TraversalEntry(networkTopology.getRootNode()));
        this.refillStack();
    }

    private void refillStack() {
        TraversalEntry traversalEntry;
        NetworkNode networkNode;
        while (!(networkNode = (traversalEntry = this.traversalStack.peek()).getNetworkNode()).isLeafNode()) {
            NetworkNode childNode = networkNode.getChildNode(traversalEntry.getChildrenVisited());
            this.traversalStack.add(new TraversalEntry(childNode));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.traversalStack.isEmpty();
    }

    @Override
    public NetworkNode next() {
        TraversalEntry traversalEntry = this.traversalStack.pop();
        NetworkNode networkNode = traversalEntry.networkNode;
        if (!this.traversalStack.isEmpty()) {
            TraversalEntry parentTraversalEntry = this.traversalStack.peek();
            parentTraversalEntry.increaseChildrenVisited();
            if (parentTraversalEntry.getChildrenVisited() < parentTraversalEntry.getNetworkNode().getNumberOfChildNodes()) {
                this.refillStack();
            }
        }
        return networkNode;
    }

    @Override
    public void remove() {
    }

    private static class TraversalEntry {
        private NetworkNode networkNode;
        private int childrenVisited = 0;

        public TraversalEntry(NetworkNode networkNode) {
            this.networkNode = networkNode;
        }

        public NetworkNode getNetworkNode() {
            return this.networkNode;
        }

        public int getChildrenVisited() {
            return this.childrenVisited;
        }

        public void increaseChildrenVisited() {
            ++this.childrenVisited;
        }
    }
}

