/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class FlatMapDriver<IT, OT>
implements PactDriver<FlatMapFunction<IT, OT>, OT> {
    private PactTaskContext<FlatMapFunction<IT, OT>, OT> taskContext;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<FlatMapFunction<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatMapFunction<IT, OT>> getStubType() {
        Class<FlatMapFunction> clazz = FlatMapFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return false;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        MutableObjectIterator input = this.taskContext.getInput(0);
        FlatMapFunction<IT, OT> function = this.taskContext.getStub();
        Collector<OT> output = this.taskContext.getOutputCollector();
        Object record = this.taskContext.getInputSerializer(0).getSerializer().createInstance();
        while (this.running && (record = input.next(record)) != null) {
            function.flatMap(record, output);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

