/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.bufferprovider;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.core.memory.MemorySegment;

public final class GlobalBufferPool {
    private static final Log LOG = LogFactory.getLog(GlobalBufferPool.class);
    private final int numBuffers;
    private final int bufferSize;
    private final Queue<MemorySegment> buffers;
    private boolean isDestroyed;

    public GlobalBufferPool(int numBuffers, int bufferSize) {
        this.numBuffers = numBuffers;
        this.bufferSize = bufferSize;
        this.buffers = new ArrayBlockingQueue<MemorySegment>(numBuffers);
        int mb = 0x100000;
        int memRequiredMb = numBuffers * bufferSize / 0x100000;
        for (int i = 0; i < numBuffers; ++i) {
            try {
                byte[] buf = new byte[bufferSize];
                this.buffers.add(new MemorySegment(buf));
                continue;
            }
            catch (OutOfMemoryError err) {
                int memAllocatedMb = (i + 1) * bufferSize / 0x100000;
                String msg = String.format("Tried to allocate %d buffers of size %d bytes each (total: %d MB) and ran out of memory after %d buffers (%d MB).", numBuffers, bufferSize, memRequiredMb, i + 1, memAllocatedMb);
                throw new OutOfMemoryError(msg);
            }
        }
        LOG.info((Object)String.format("Allocated %d buffers of size %d bytes each (total: %d MB).", numBuffers, bufferSize, memRequiredMb));
    }

    public MemorySegment requestBuffer() {
        return this.buffers.poll();
    }

    public void returnBuffer(MemorySegment buffer) {
        this.buffers.add(buffer);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int numBuffers() {
        return this.numBuffers;
    }

    public int numAvailableBuffers() {
        return this.buffers.size();
    }

    public synchronized void destroy() {
        if (!this.isDestroyed) {
            this.isDestroyed = true;
            for (MemorySegment buffer : this.buffers) {
                buffer.free();
            }
            this.buffers.clear();
        }
    }
}

