/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObject;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DiskFileUpload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestHandler.class);
    private static final Charset ENCODING = ConfigConstants.DEFAULT_CHARSET;
    private static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(true);
    private final File tmpDir;
    private HttpRequest currentRequest;
    private HttpPostRequestDecoder currentDecoder;
    private String currentRequestPath;

    public HttpRequestHandler(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.currentDecoder != null) {
            this.currentDecoder.cleanFiles();
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        block13: {
            try {
                if (msg instanceof HttpRequest) {
                    this.currentRequest = (HttpRequest)msg;
                    this.currentRequestPath = null;
                    if (this.currentDecoder != null) {
                        this.currentDecoder.destroy();
                        this.currentDecoder = null;
                    }
                    if (this.currentRequest.method() == HttpMethod.GET || this.currentRequest.method() == HttpMethod.DELETE) {
                        ctx.fireChannelRead((Object)this.currentRequest);
                        break block13;
                    }
                    if (this.currentRequest.method() == HttpMethod.POST) {
                        this.currentRequestPath = new QueryStringDecoder(this.currentRequest.uri(), ENCODING).path();
                        this.currentDecoder = new HttpPostRequestDecoder(DATA_FACTORY, this.currentRequest, ENCODING);
                        break block13;
                    }
                    throw new IOException("Unsupported HTTP method: " + this.currentRequest.method().name());
                }
                if (this.currentDecoder != null && msg instanceof HttpContent) {
                    HttpContent chunk = (HttpContent)msg;
                    this.currentDecoder.offer(chunk);
                    try {
                        while (this.currentDecoder.hasNext()) {
                            DiskFileUpload file;
                            InterfaceHttpData data = this.currentDecoder.next();
                            if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload || this.tmpDir == null || !(file = (DiskFileUpload)data).isCompleted()) continue;
                            String name = file.getFilename();
                            File target = new File(this.tmpDir, String.valueOf(UUID.randomUUID()) + "_" + name);
                            if (!this.tmpDir.exists()) {
                                HttpRequestHandler.logExternalUploadDirDeletion(this.tmpDir);
                                HttpRequestHandler.checkAndCreateUploadDir(this.tmpDir);
                            }
                            file.renameTo(target);
                            QueryStringEncoder encoder = new QueryStringEncoder(this.currentRequestPath);
                            encoder.addParam("filepath", target.getAbsolutePath());
                            encoder.addParam("filename", name);
                            this.currentRequest.setUri(encoder.toString());
                        }
                    }
                    catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
                        // empty catch block
                    }
                    if (chunk instanceof LastHttpContent) {
                        HttpRequest request = this.currentRequest;
                        this.currentRequest = null;
                        this.currentRequestPath = null;
                        this.currentDecoder.destroy();
                        this.currentDecoder = null;
                        ctx.fireChannelRead((Object)request);
                    }
                    break block13;
                }
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
            catch (Throwable t) {
                this.currentRequest = null;
                this.currentRequestPath = null;
                if (this.currentDecoder != null) {
                    this.currentDecoder.destroy();
                    this.currentDecoder = null;
                }
                if (!ctx.channel().isActive()) break block13;
                byte[] bytes = ExceptionUtils.stringifyException((Throwable)t).getBytes(ENCODING);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])bytes));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                ctx.writeAndFlush((Object)response);
            }
        }
    }

    public static void logExternalUploadDirDeletion(File uploadDir) {
        LOG.warn("Jar storage directory {} has been deleted externally. Previously uploaded jars are no longer available.", (Object)uploadDir.getAbsolutePath());
    }

    public static synchronized void checkAndCreateUploadDir(File uploadDir) throws IOException {
        if (uploadDir.exists() && uploadDir.canWrite()) {
            LOG.info("Using directory {} for web frontend JAR file uploads.", (Object)uploadDir);
        } else if (uploadDir.mkdirs() && uploadDir.canWrite()) {
            LOG.info("Created directory {} for web frontend JAR file uploads.", (Object)uploadDir);
        } else {
            LOG.warn("Jar upload directory {} cannot be created or is not writable.", (Object)uploadDir.getAbsolutePath());
            throw new IOException(String.format("Jar upload directory %s cannot be created or is not writable.", uploadDir.getAbsolutePath()));
        }
    }
}

