/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HistoryServerStaticFileServerHandler
extends SimpleChannelInboundHandler<RoutedRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryServerStaticFileServerHandler.class);
    private final File rootPath;

    public HistoryServerStaticFileServerHandler(File rootPath) throws IOException {
        this.rootPath = ((File)Preconditions.checkNotNull((Object)rootPath)).getCanonicalFile();
    }

    public void channelRead0(ChannelHandlerContext ctx, RoutedRequest routedRequest) throws Exception {
        String requestPath = routedRequest.getPath();
        try {
            this.respondWithFile(ctx, routedRequest.getRequest(), requestPath);
        }
        catch (RestHandlerException rhe) {
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)routedRequest.getRequest(), (ErrorResponseBody)new ErrorResponseBody(rhe.getMessage()), (HttpResponseStatus)rhe.getHttpResponseStatus(), Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondWithFile(ChannelHandlerContext ctx, HttpRequest request, String requestPath) throws IOException, ParseException, RestHandlerException {
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        File file;
        block34: {
            if (requestPath.endsWith("/")) {
                requestPath = requestPath + "index.html";
            }
            if (!requestPath.contains(".")) {
                requestPath = requestPath + ".json";
            }
            if ((file = new File(this.rootPath, requestPath)).exists()) break block34;
            ClassLoader cl = HistoryServerStaticFileServerHandler.class.getClassLoader();
            try (InputStream resourceStream = cl.getResourceAsStream("web" + requestPath);){
                boolean success = false;
                try {
                    block35: {
                        URI requestedURI;
                        if (resourceStream == null) break block35;
                        URL root = cl.getResource("web");
                        URL requested = cl.getResource("web" + requestPath);
                        if (root == null) break;
                        if (requested == null) break;
                        URI rootURI = new URI(root.getPath()).normalize();
                        if (!rootURI.relativize(requestedURI = new URI(requested.getPath()).normalize()).equals(requestedURI)) {
                            LOG.debug("Loading missing file from classloader: {}", (Object)requestPath);
                            file.getParentFile().mkdirs();
                            Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
                            success = true;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    LOG.error("error while responding", t);
                }
                finally {
                    if (!success) {
                        LOG.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                        throw new NotFoundException("File not found.");
                    }
                }
            }
        }
        StaticFileServerHandler.checkFileValidity((File)file, (File)this.rootPath, (Logger)LOG);
        String ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified((ChannelHandlerContext)ctx);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find file {}.", (Object)file.getAbsolutePath());
            }
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
            return;
        }
        try {
            ChannelFuture lastContentFuture;
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, (File)file);
            if (!requestPath.equals("/joboverview.json")) {
                StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, (File)file);
            }
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            raf.close();
            LOG.error("Failed to serve file.", (Throwable)e);
            throw new RestHandlerException("Internal server error.", HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            LOG.error("Caught exception", cause);
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (boolean)false, (ErrorResponseBody)new ErrorResponseBody("Internal server error."), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }
}

