/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.ParquetInputFormat;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetPojoInputFormat<E>
extends ParquetInputFormat<E> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetPojoInputFormat.class);
    private final Class<E> pojoTypeClass;
    private final TypeSerializer<E> typeSerializer;
    private transient Field[] pojoFields;

    public ParquetPojoInputFormat(Path filePath, MessageType messageType, PojoTypeInfo<E> pojoTypeInfo) {
        super(filePath, messageType);
        Preconditions.checkNotNull((Object)messageType, (String)"messageType");
        this.pojoTypeClass = pojoTypeInfo.getTypeClass();
        this.typeSerializer = pojoTypeInfo.createSerializer(new ExecutionConfig());
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        this.findAllFields(this.pojoTypeClass, fieldMap);
        this.selectFields(fieldMap.keySet().toArray(new String[0]));
    }

    public ParquetPojoInputFormat(Path filePath, PojoTypeInfo<E> pojoTypeInfo) {
        this(filePath, null, pojoTypeInfo);
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.pojoFields = new Field[this.getFieldNames().length];
        LOG.error("Fields number is {}.", (Object)this.getFieldNames().length);
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        this.findAllFields(this.pojoTypeClass, fieldMap);
        for (int i = 0; i < this.getFieldNames().length; ++i) {
            String fieldName = this.getFieldNames()[i];
            this.pojoFields[i] = (Field)fieldMap.get(fieldName);
            if (this.pojoFields[i] == null) {
                throw new RuntimeException(String.format("There is no field called %s in %s", fieldName, this.pojoTypeClass.getName()));
            }
            this.pojoFields[i].setAccessible(true);
        }
    }

    private void findAllFields(Class<?> clazz, Map<String, Field> fieldMap) {
        for (Field field : clazz.getDeclaredFields()) {
            fieldMap.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            this.findAllFields(clazz.getSuperclass(), fieldMap);
        }
    }

    @Override
    protected E convert(Row row) {
        Object result = this.typeSerializer.createInstance();
        for (int i = 0; i < row.getArity(); ++i) {
            try {
                if (this.pojoFields[i].getType().isAssignableFrom(List.class)) {
                    this.pojoFields[i].set(result, Collections.singletonList(row.getField(i)));
                    continue;
                }
                this.pojoFields[i].set(result, row.getField(i));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Parsed value could not be set in POJO field %s", this.getFieldNames()[i]));
            }
        }
        return (E)result;
    }

    private static <E> TypeInformation<?>[] extractTypeInfos(PojoTypeInfo<E> pojoTypeInfo, String[] fieldNames) {
        Preconditions.checkNotNull(pojoTypeInfo);
        Preconditions.checkNotNull((Object)fieldNames);
        Preconditions.checkArgument((pojoTypeInfo.getArity() >= fieldNames.length ? 1 : 0) != 0);
        TypeInformation[] fieldTypes = new TypeInformation[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Preconditions.checkNotNull((Object)fieldName, (String)"The field can't be null");
            int fieldPos = pojoTypeInfo.getFieldIndex(fieldName);
            Preconditions.checkArgument((fieldPos >= 0 ? 1 : 0) != 0, (Object)String.format("Field %s is not a member of POJO type %s", fieldName, pojoTypeInfo.getTypeClass().getName()));
            fieldTypes[i] = pojoTypeInfo.getTypeAt(fieldPos);
        }
        return fieldTypes;
    }
}

