/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.operators.AllGroupReduceProperties;
import org.apache.flink.optimizer.operators.AllGroupWithPartialPreGroupProperties;
import org.apache.flink.optimizer.operators.GroupReduceProperties;
import org.apache.flink.optimizer.operators.GroupReduceWithCombineProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;

public class GroupReduceNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;
    private final String operatorName;
    private GroupReduceNode combinerUtilityNode;

    public GroupReduceNode(GroupReduceOperatorBase<?, ?, ?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        this.operatorName = "GroupReduce";
        if (this.keys == null) {
            this.setParallelism(1);
        }
        this.possibleProperties = this.initPossibleProperties(operator.getCustomPartitioner());
    }

    private GroupReduceNode(GroupReduceNode reducerToCopyForCombiner) {
        super(reducerToCopyForCombiner);
        this.operatorName = "GroupCombine";
        this.possibleProperties = Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<OperatorDescriptorSingle> initPossibleProperties(Partitioner<?> customPartitioner) {
        boolean useCombiner;
        Configuration conf = this.getOperator().getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            if ("LOCAL_STRATEGY_SORT".equals(localStrategy)) {
                useCombiner = false;
            } else {
                if (!"LOCAL_STRATEGY_COMBINING_SORT".equals(localStrategy)) throw new CompilerException("Invalid local strategy hint for match contract: " + localStrategy);
                if (!this.isCombineable()) {
                    Optimizer.LOG.warn("Strategy hint for GroupReduce '" + this.getOperator().getName() + "' requires combinable reduce, but user function is not marked combinable.");
                }
                useCombiner = true;
            }
        } else {
            useCombiner = this.isCombineable();
        }
        Ordering groupOrder = null;
        if (this.getOperator() != null && (groupOrder = this.getOperator().getGroupOrder()) != null && groupOrder.getNumberOfFields() == 0) {
            groupOrder = null;
        }
        OperatorDescriptorSingle operatorDescriptorSingle = useCombiner ? (this.keys == null ? new AllGroupWithPartialPreGroupProperties() : new GroupReduceWithCombineProperties(this.keys, groupOrder, customPartitioner)) : (this.keys == null ? new AllGroupReduceProperties() : new GroupReduceProperties(this.keys, groupOrder, customPartitioner));
        return Collections.singletonList(operatorDescriptorSingle);
    }

    public GroupReduceOperatorBase<?, ?, ?> getOperator() {
        return (GroupReduceOperatorBase)super.getOperator();
    }

    public boolean isCombineable() {
        return this.getOperator().isCombinable();
    }

    @Override
    public String getOperatorName() {
        return this.operatorName;
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected SemanticProperties getSemanticPropertiesForLocalPropertyFiltering() {
        SingleInputSemanticProperties origProps = this.getOperator().getSemanticProperties();
        SingleInputSemanticProperties filteredProps = new SingleInputSemanticProperties();
        FieldSet readSet = origProps.getReadFields(0);
        if (readSet != null) {
            filteredProps.addReadFields(readSet);
        }
        if (this.keys != null) {
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext()) {
                int f = (Integer)iterator.next();
                FieldSet targets = origProps.getForwardingTargetFields(0, f);
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    int t = (Integer)iterator2.next();
                    filteredProps.addForwardedField(f, t);
                }
            }
        }
        return filteredProps;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    public GroupReduceNode getCombinerUtilityNode() {
        if (this.combinerUtilityNode == null) {
            this.combinerUtilityNode = new GroupReduceNode(this);
            this.combinerUtilityNode.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
            this.combinerUtilityNode.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        }
        return this.combinerUtilityNode;
    }
}

