/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.NumericSummaryAggregator;

@Internal
public class IntegerSummaryAggregator
extends NumericSummaryAggregator<Integer> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Aggregator<Integer, Integer> initMin() {
        return new MinIntegerAggregator();
    }

    @Override
    protected Aggregator<Integer, Integer> initMax() {
        return new MaxIntegerAggregator();
    }

    @Override
    protected Aggregator<Integer, Integer> initSum() {
        return new SumIntegerAggregator();
    }

    @Override
    protected boolean isNan(Integer number) {
        return false;
    }

    @Override
    protected boolean isInfinite(Integer number) {
        return false;
    }

    public static class SumIntegerAggregator
    implements Aggregator<Integer, Integer> {
        private int sum = 0;

        @Override
        public void aggregate(Integer value) {
            this.sum += value.intValue();
        }

        @Override
        public void combine(Aggregator<Integer, Integer> other) {
            this.sum += ((SumIntegerAggregator)other).sum;
        }

        @Override
        public Integer result() {
            return this.sum;
        }
    }

    public static class MaxIntegerAggregator
    implements Aggregator<Integer, Integer> {
        private int max = Integer.MIN_VALUE;

        @Override
        public void aggregate(Integer value) {
            this.max = Math.max(this.max, value);
        }

        @Override
        public void combine(Aggregator<Integer, Integer> other) {
            this.max = Math.max(this.max, ((MaxIntegerAggregator)other).max);
        }

        @Override
        public Integer result() {
            return this.max;
        }
    }

    public static class MinIntegerAggregator
    implements Aggregator<Integer, Integer> {
        private int min = Integer.MAX_VALUE;

        @Override
        public void aggregate(Integer value) {
            this.min = Math.min(this.min, value);
        }

        @Override
        public void combine(Aggregator<Integer, Integer> other) {
            this.min = Math.min(this.min, ((MinIntegerAggregator)other).min);
        }

        @Override
        public Integer result() {
            return this.min;
        }
    }
}

