/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
class UploadThrottle {
    private final long maxBytesInFlight;
    private long inFlightBytesCounter = 0L;

    UploadThrottle(long maxBytesInFlight) {
        this.maxBytesInFlight = maxBytesInFlight;
    }

    public void seizeCapacity(long bytes) throws IllegalStateException {
        Preconditions.checkState((boolean)this.hasCapacity());
        this.inFlightBytesCounter += bytes;
    }

    public void releaseCapacity(long bytes) {
        this.inFlightBytesCounter -= bytes;
    }

    public boolean hasCapacity() {
        return this.inFlightBytesCounter < this.maxBytesInFlight;
    }
}

