/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiFunction;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.util.Preconditions;

class OutputStreamWithPos
extends OutputStream {
    protected final Path path;
    protected OutputStream outputStream;
    protected long pos;
    protected boolean compression;
    protected final OutputStream originalStream;

    public OutputStreamWithPos(OutputStream outputStream, Path path) {
        this.outputStream = (OutputStream)Preconditions.checkNotNull((Object)outputStream);
        this.originalStream = (OutputStream)Preconditions.checkNotNull((Object)outputStream);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.pos = 0L;
        this.compression = false;
    }

    protected OutputStream wrapInternal(boolean compression, int bufferSize, OutputStream fsStream) throws IOException {
        fsStream.write(compression ? 1 : 0);
        StreamCompressionDecorator instance = compression ? SnappyStreamCompressionDecorator.INSTANCE : UncompressedStreamCompressionDecorator.INSTANCE;
        return new BufferedOutputStream(instance.decorateWithCompression(fsStream), bufferSize);
    }

    public void wrap(boolean compression, int bufferSize) throws IOException {
        this.compression = compression;
        this.outputStream = this.wrapInternal(compression, bufferSize, this.originalStream);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.pos += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.close();
            this.originalStream.close();
        }
        catch (IOException e) {
            this.getPath().getFileSystem().delete(this.getPath(), true);
        }
    }

    public long getPos() {
        return this.pos;
    }

    public Path getPath() {
        return this.path;
    }

    public StreamStateHandle getHandle(BiFunction<Path, Long, StreamStateHandle> handleFactory) {
        return handleFactory.apply(this.path, this.pos);
    }
}

