/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangelogStreamWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogStreamWrapper.class);

    ChangelogStreamWrapper() {
    }

    static DataInputViewStreamWrapper wrap(InputStream stream) throws IOException {
        final BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        boolean compressed = bufferedStream.read() == 1;
        return new DataInputViewStreamWrapper(compressed ? SnappyStreamCompressionDecorator.INSTANCE.decorateWithCompression((InputStream)bufferedStream) : bufferedStream){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    bufferedStream.close();
                }
            }
        };
    }

    static DataInputViewStreamWrapper wrapAndSeek(InputStream stream, long offset) throws IOException {
        DataInputViewStreamWrapper wrappedStream = ChangelogStreamWrapper.wrap(stream);
        if (offset != 0L) {
            LOG.debug("seek to {}", (Object)offset);
            wrappedStream.skipBytesToRead((int)offset);
        }
        return wrappedStream;
    }
}

