/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;

@ThreadSafe
public class ChangelogStorageMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    private static final int WINDOW_SIZE = 1000;
    private final Counter uploadsCounter = this.counter("ChangelogStorage.numberOfUploadRequests", (Counter)new ThreadSafeSimpleCounter());
    private final Counter uploadFailuresCounter;
    private final Histogram uploadBatchSizes = this.histogram("ChangelogStorage.uploadBatchSizes", (Histogram)new DescriptiveStatisticsHistogram(1000));
    private final Histogram uploadSizes;
    private final Histogram uploadLatenciesNanos;
    private final Histogram attemptsPerUpload = this.histogram("ChangelogStorage.attemptsPerUpload", (Histogram)new DescriptiveStatisticsHistogram(1000));
    private final Histogram totalAttemptsPerUpload = this.histogram("ChangelogStorage.totalAttemptsPerUpload", (Histogram)new DescriptiveStatisticsHistogram(1000));
    private static final String PREFIX = "ChangelogStorage";
    public static final String CHANGELOG_STORAGE_NUM_UPLOAD_REQUESTS = "ChangelogStorage.numberOfUploadRequests";
    public static final String CHANGELOG_STORAGE_NUM_UPLOAD_FAILURES = "ChangelogStorage.numberOfUploadFailures";
    public static final String CHANGELOG_STORAGE_UPLOAD_SIZES = "ChangelogStorage.uploadSizes";
    public static final String CHANGELOG_STORAGE_UPLOAD_LATENCIES_NANOS = "ChangelogStorage.uploadLatenciesNanos";
    public static final String CHANGELOG_STORAGE_ATTEMPTS_PER_UPLOAD = "ChangelogStorage.attemptsPerUpload";
    public static final String CHANGELOG_STORAGE_TOTAL_ATTEMPTS_PER_UPLOAD = "ChangelogStorage.totalAttemptsPerUpload";
    public static final String CHANGELOG_STORAGE_UPLOAD_BATCH_SIZES = "ChangelogStorage.uploadBatchSizes";
    public static final String CHANGELOG_STORAGE_UPLOAD_QUEUE_SIZE = "ChangelogStorage.uploadQueueSize";

    public ChangelogStorageMetricGroup(MetricGroup parent) {
        super(parent);
        this.uploadSizes = this.histogram(CHANGELOG_STORAGE_UPLOAD_SIZES, (Histogram)new DescriptiveStatisticsHistogram(1000));
        this.uploadLatenciesNanos = this.histogram(CHANGELOG_STORAGE_UPLOAD_LATENCIES_NANOS, (Histogram)new DescriptiveStatisticsHistogram(1000));
        this.uploadFailuresCounter = this.counter(CHANGELOG_STORAGE_NUM_UPLOAD_FAILURES, (Counter)new ThreadSafeSimpleCounter());
    }

    public Counter getUploadsCounter() {
        return this.uploadsCounter;
    }

    public Counter getUploadFailuresCounter() {
        return this.uploadFailuresCounter;
    }

    public Histogram getAttemptsPerUpload() {
        return this.attemptsPerUpload;
    }

    public Histogram getTotalAttemptsPerUpload() {
        return this.totalAttemptsPerUpload;
    }

    public Histogram getUploadBatchSizes() {
        return this.uploadBatchSizes;
    }

    public Histogram getUploadSizes() {
        return this.uploadSizes;
    }

    public Histogram getUploadLatenciesNanos() {
        return this.uploadLatenciesNanos;
    }

    public void registerUploadQueueSizeGauge(Gauge<Integer> gauge) {
        this.gauge(CHANGELOG_STORAGE_UPLOAD_QUEUE_SIZE, gauge);
    }
}

