/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.kafka.sink.KafkaCommittable;
import org.apache.flink.core.io.SimpleVersionedSerializer;

class KafkaCommittableSerializer
implements SimpleVersionedSerializer<KafkaCommittable> {
    KafkaCommittableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(KafkaCommittable state) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeShort(state.getEpoch());
                out.writeLong(state.getProducerId());
                out.writeUTF(state.getTransactionalId());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public KafkaCommittable deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            KafkaCommittable kafkaCommittable;
            try (DataInputStream in = new DataInputStream(bais);){
                short epoch = in.readShort();
                long producerId = in.readLong();
                String transactionalId = in.readUTF();
                kafkaCommittable = new KafkaCommittable(producerId, epoch, transactionalId, null);
            }
            return kafkaCommittable;
        }
    }
}

