/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.metrics;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;

@Internal
public class KafkaClusterMetricGroup
implements SourceReaderMetricGroup {
    public static final String DYNAMIC_KAFKA_SOURCE_METRIC_GROUP = "DynamicKafkaSource";
    public static final String KAFKA_CLUSTER_GROUP_NAME = "kafkaCluster";
    private final MetricGroup internalClusterSpecificMetricGroup;
    private final OperatorIOMetricGroup delegateIOMetricGroup;

    public KafkaClusterMetricGroup(MetricGroup dynamicKafkaSourceMetricGroup, SourceReaderMetricGroup delegateSourceReaderMetricGroup, String kafkaClusterId) {
        this.internalClusterSpecificMetricGroup = dynamicKafkaSourceMetricGroup.addGroup(KAFKA_CLUSTER_GROUP_NAME, kafkaClusterId);
        this.delegateIOMetricGroup = delegateSourceReaderMetricGroup.getIOMetricGroup();
    }

    MetricGroup getInternalClusterSpecificMetricGroup() {
        return this.internalClusterSpecificMetricGroup;
    }

    public Counter getNumRecordsInErrorsCounter() {
        throw new UnsupportedOperationException("This is not invoked/supported by KafkaSourceReader as of Flink 1.14.");
    }

    public void setPendingBytesGauge(Gauge<Long> gauge) {
        throw new UnsupportedOperationException("This is not invoked/supported by KafkaSourceReader as of Flink 1.14.");
    }

    public void setPendingRecordsGauge(Gauge<Long> pendingRecordsGauge) {
        this.gauge("pendingRecords", pendingRecordsGauge);
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return this.delegateIOMetricGroup;
    }

    public Counter counter(String name) {
        return this.internalClusterSpecificMetricGroup.counter(name);
    }

    public <C extends Counter> C counter(String name, C counter) {
        return (C)this.internalClusterSpecificMetricGroup.counter(name, counter);
    }

    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        return (G)this.internalClusterSpecificMetricGroup.gauge(name, gauge);
    }

    public <H extends Histogram> H histogram(String name, H histogram) {
        return (H)this.internalClusterSpecificMetricGroup.histogram(name, histogram);
    }

    public <M extends Meter> M meter(String name, M meter) {
        return (M)this.internalClusterSpecificMetricGroup.meter(name, meter);
    }

    public MetricGroup addGroup(String name) {
        return this.internalClusterSpecificMetricGroup.addGroup(name);
    }

    public MetricGroup addGroup(String key, String value) {
        return this.internalClusterSpecificMetricGroup.addGroup(key, value);
    }

    public String[] getScopeComponents() {
        return this.internalClusterSpecificMetricGroup.getScopeComponents();
    }

    public Map<String, String> getAllVariables() {
        return this.internalClusterSpecificMetricGroup.getAllVariables();
    }

    public String getMetricIdentifier(String metricName) {
        return this.internalClusterSpecificMetricGroup.getMetricIdentifier(metricName);
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        return this.internalClusterSpecificMetricGroup.getMetricIdentifier(metricName, filter);
    }
}

