/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.connector.jdbc.xa.CheckpointAndXid;
import org.apache.flink.connector.jdbc.xa.XaFacade;
import org.apache.flink.connector.jdbc.xa.XaGroupOps;
import org.apache.flink.connector.jdbc.xa.XidGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class XaGroupOpsImpl
implements XaGroupOps {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(XaGroupOpsImpl.class);
    private final XaFacade xaFacade;

    XaGroupOpsImpl(XaFacade xaFacade) {
        this.xaFacade = xaFacade;
    }

    @Override
    public XaGroupOps.GroupXaOperationResult<CheckpointAndXid> commit(List<CheckpointAndXid> xids, boolean allowOutOfOrderCommits, int maxCommitAttempts) {
        XaGroupOps.GroupXaOperationResult<CheckpointAndXid> result = new XaGroupOps.GroupXaOperationResult<CheckpointAndXid>();
        int origSize = xids.size();
        LOG.debug("commit {} transactions", (Object)origSize);
        Iterator<CheckpointAndXid> i = xids.iterator();
        while (i.hasNext() && (result.hasNoFailures() || allowOutOfOrderCommits)) {
            CheckpointAndXid x = i.next();
            i.remove();
            try {
                this.xaFacade.commit(x.xid, x.restored);
                result.succeeded(x);
            }
            catch (XaFacade.TransientXaException e) {
                result.failedTransiently(x.withAttemptsIncremented(), e);
            }
            catch (Exception e) {
                result.failed(x, e);
            }
        }
        result.getForRetry().addAll(xids);
        result.throwIfAnyFailed("commit");
        XaGroupOpsImpl.throwIfAnyReachedMaxAttempts(result, maxCommitAttempts);
        result.getTransientFailure().ifPresent(f -> LOG.warn("failed to commit {} transactions out of {} (keep them to retry later)", new Object[]{result.getForRetry().size(), origSize, f}));
        return result;
    }

    @Override
    public XaGroupOps.GroupXaOperationResult<Xid> failOrRollback(Collection<Xid> xids) {
        XaGroupOps.GroupXaOperationResult<Xid> result = new XaGroupOps.GroupXaOperationResult<Xid>();
        if (xids.isEmpty()) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rolling back {} transactions: {}", (Object)xids.size(), xids);
        }
        for (Xid x : xids) {
            try {
                this.xaFacade.failAndRollback(x);
                result.succeeded(x);
            }
            catch (XaFacade.TransientXaException e) {
                LOG.info("unable to fail/rollback transaction, xid={}: {}", (Object)x, (Object)e.getMessage());
                result.failedTransiently(x, e);
            }
            catch (Exception e) {
                LOG.warn("unable to fail/rollback transaction, xid={}: {}", (Object)x, (Object)e.getMessage());
                result.failed(x, e);
            }
        }
        if (!result.getForRetry().isEmpty()) {
            LOG.info("failed to roll back {} transactions", (Object)result.getForRetry().size());
        }
        return result;
    }

    @Override
    public void recoverAndRollback(RuntimeContext runtimeContext, XidGenerator xidGenerator) {
        Collection<Xid> recovered = this.xaFacade.recover();
        if (recovered.isEmpty()) {
            return;
        }
        LOG.warn("rollback {} recovered transactions", (Object)recovered.size());
        for (Xid xid : recovered) {
            if (!xidGenerator.belongsToSubtask(xid, runtimeContext)) continue;
            try {
                this.xaFacade.rollback(xid);
            }
            catch (Exception e) {
                LOG.info("unable to rollback recovered transaction, xid={}", (Object)xid, (Object)e);
            }
        }
    }

    private static void throwIfAnyReachedMaxAttempts(XaGroupOps.GroupXaOperationResult<CheckpointAndXid> result, int maxAttempts) {
        ArrayList<CheckpointAndXid> reached = null;
        for (CheckpointAndXid x : result.getForRetry()) {
            if (x.attempts < maxAttempts) continue;
            if (reached == null) {
                reached = new ArrayList<CheckpointAndXid>();
            }
            reached.add(x);
        }
        if (reached != null) {
            throw new RuntimeException(String.format("reached max number of commit attempts (%d) for transactions: %s", maxAttempts, reached));
        }
    }
}

