/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class JdbcTypeUtil {
    private static final Map<TypeInformation<?>, Integer> TYPE_MAPPING;
    private static final Map<LogicalTypeRoot, Integer> LOGICAL_TYPE_MAPPING;

    private JdbcTypeUtil() {
    }

    @Deprecated
    public static int typeInformationToSqlType(TypeInformation<?> type) {
        if (TYPE_MAPPING.containsKey(type)) {
            return TYPE_MAPPING.get(type);
        }
        if (type instanceof ObjectArrayTypeInfo || type instanceof PrimitiveArrayTypeInfo) {
            return 2003;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static int logicalTypeToSqlType(LogicalTypeRoot typeRoot) {
        if (LOGICAL_TYPE_MAPPING.containsKey(typeRoot)) {
            return LOGICAL_TYPE_MAPPING.get(typeRoot);
        }
        throw new IllegalArgumentException("Unsupported typeRoot: " + typeRoot);
    }

    static {
        HashMap<Object, Integer> m = new HashMap<Object, Integer>();
        m.put(BasicTypeInfo.STRING_TYPE_INFO, 12);
        m.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, 16);
        m.put(BasicTypeInfo.BYTE_TYPE_INFO, -6);
        m.put(BasicTypeInfo.SHORT_TYPE_INFO, 5);
        m.put(BasicTypeInfo.INT_TYPE_INFO, 4);
        m.put(BasicTypeInfo.LONG_TYPE_INFO, -5);
        m.put(BasicTypeInfo.FLOAT_TYPE_INFO, 7);
        m.put(BasicTypeInfo.DOUBLE_TYPE_INFO, 8);
        m.put(SqlTimeTypeInfo.DATE, 91);
        m.put(SqlTimeTypeInfo.TIME, 92);
        m.put(SqlTimeTypeInfo.TIMESTAMP, 93);
        m.put(LocalTimeTypeInfo.LOCAL_DATE, 91);
        m.put(LocalTimeTypeInfo.LOCAL_TIME, 92);
        m.put(LocalTimeTypeInfo.LOCAL_DATE_TIME, 93);
        m.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, 3);
        m.put(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, -2);
        TYPE_MAPPING = Collections.unmodifiableMap(m);
        LOGICAL_TYPE_MAPPING = ImmutableMap.builder().put((Object)LogicalTypeRoot.VARCHAR, (Object)12).put((Object)LogicalTypeRoot.CHAR, (Object)1).put((Object)LogicalTypeRoot.VARBINARY, (Object)-3).put((Object)LogicalTypeRoot.BOOLEAN, (Object)16).put((Object)LogicalTypeRoot.BINARY, (Object)-2).put((Object)LogicalTypeRoot.TINYINT, (Object)-6).put((Object)LogicalTypeRoot.SMALLINT, (Object)5).put((Object)LogicalTypeRoot.INTEGER, (Object)4).put((Object)LogicalTypeRoot.BIGINT, (Object)-5).put((Object)LogicalTypeRoot.FLOAT, (Object)7).put((Object)LogicalTypeRoot.DOUBLE, (Object)8).put((Object)LogicalTypeRoot.DATE, (Object)91).put((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, (Object)93).put((Object)LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, (Object)2014).put((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, (Object)92).put((Object)LogicalTypeRoot.DECIMAL, (Object)3).put((Object)LogicalTypeRoot.ARRAY, (Object)2003).build();
    }
}

