/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectLoader;
import org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcReadOptions;
import org.apache.flink.connector.jdbc.table.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSink;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSource;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class JdbcDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "jdbc";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        this.validateConfigOptions(config, context.getClassLoader());
        JdbcDynamicTableFactory.validateDataTypeWithJdbcDialect(context.getPhysicalRowDataType(), (String)config.get(JdbcConnectorOptions.URL), context.getClassLoader());
        org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions jdbcOptions = this.getJdbcOptions(config, context.getClassLoader());
        return new JdbcDynamicTableSink(jdbcOptions, this.getJdbcExecutionOptions(config), this.getJdbcDmlOptions(jdbcOptions, context.getPhysicalRowDataType(), context.getPrimaryKeyIndexes()), context.getPhysicalRowDataType());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        this.validateConfigOptions(config, context.getClassLoader());
        JdbcDynamicTableFactory.validateDataTypeWithJdbcDialect(context.getPhysicalRowDataType(), (String)config.get(JdbcConnectorOptions.URL), context.getClassLoader());
        return new JdbcDynamicTableSource(this.getJdbcOptions(helper.getOptions(), context.getClassLoader()), this.getJdbcReadOptions(helper.getOptions()), (Integer)helper.getOptions().get(LookupOptions.MAX_RETRIES), this.getLookupCache(config), context.getPhysicalRowDataType());
    }

    private static void validateDataTypeWithJdbcDialect(DataType dataType, String url, ClassLoader classLoader) {
        JdbcDialect dialect = JdbcDialectLoader.load(url, classLoader);
        dialect.validate((RowType)dataType.getLogicalType());
    }

    private org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions getJdbcOptions(ReadableConfig readableConfig, ClassLoader classLoader) {
        String url = (String)readableConfig.get(JdbcConnectorOptions.URL);
        JdbcConnectorOptions.Builder builder = org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions.builder().setClassLoader(classLoader).setDBUrl(url).setTableName((String)readableConfig.get(JdbcConnectorOptions.TABLE_NAME)).setDialect(JdbcDialectLoader.load(url, classLoader)).setParallelism(readableConfig.getOptional(JdbcConnectorOptions.SINK_PARALLELISM).orElse(null)).setConnectionCheckTimeoutSeconds((int)((Duration)readableConfig.get(JdbcConnectorOptions.MAX_RETRY_TIMEOUT)).getSeconds());
        readableConfig.getOptional(JdbcConnectorOptions.DRIVER).ifPresent(builder::setDriverName);
        readableConfig.getOptional(JdbcConnectorOptions.USERNAME).ifPresent(builder::setUsername);
        readableConfig.getOptional(JdbcConnectorOptions.PASSWORD).ifPresent(builder::setPassword);
        return builder.build();
    }

    private JdbcReadOptions getJdbcReadOptions(ReadableConfig readableConfig) {
        Optional partitionColumnName = readableConfig.getOptional(JdbcConnectorOptions.SCAN_PARTITION_COLUMN);
        JdbcReadOptions.Builder builder = JdbcReadOptions.builder();
        if (partitionColumnName.isPresent()) {
            builder.setPartitionColumnName((String)partitionColumnName.get());
            builder.setPartitionLowerBound((Long)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND));
            builder.setPartitionUpperBound((Long)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND));
            builder.setNumPartitions((Integer)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_NUM));
        }
        readableConfig.getOptional(JdbcConnectorOptions.SCAN_FETCH_SIZE).ifPresent(builder::setFetchSize);
        builder.setAutoCommit((Boolean)readableConfig.get(JdbcConnectorOptions.SCAN_AUTO_COMMIT));
        return builder.build();
    }

    private JdbcExecutionOptions getJdbcExecutionOptions(ReadableConfig config) {
        JdbcExecutionOptions.Builder builder = new JdbcExecutionOptions.Builder();
        builder.withBatchSize((Integer)config.get(JdbcConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS));
        builder.withBatchIntervalMs(((Duration)config.get(JdbcConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        builder.withMaxRetries((Integer)config.get(JdbcConnectorOptions.SINK_MAX_RETRIES));
        return builder.build();
    }

    private JdbcDmlOptions getJdbcDmlOptions(org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions jdbcOptions, DataType dataType, int[] primaryKeyIndexes) {
        String[] keyFields = (String[])Arrays.stream(primaryKeyIndexes).mapToObj(i -> (String)DataType.getFieldNames((DataType)dataType).get(i)).toArray(String[]::new);
        return JdbcDmlOptions.builder().withTableName(jdbcOptions.getTableName()).withDialect(jdbcOptions.getDialect()).withFieldNames(DataType.getFieldNames((DataType)dataType).toArray(new String[0])).withKeyFields((String[])(keyFields.length > 0 ? keyFields : null)).build();
    }

    @Nullable
    private LookupCache getLookupCache(ReadableConfig tableOptions) {
        DefaultLookupCache cache = null;
        if ((Long)tableOptions.get(JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS) > 0L && ((Duration)tableOptions.get(JdbcConnectorOptions.LOOKUP_CACHE_TTL)).compareTo(Duration.ZERO) > 0) {
            cache = DefaultLookupCache.newBuilder().maximumSize(((Long)tableOptions.get(JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS)).longValue()).expireAfterWrite((Duration)tableOptions.get(JdbcConnectorOptions.LOOKUP_CACHE_TTL)).cacheMissingKey(((Boolean)tableOptions.get(JdbcConnectorOptions.LOOKUP_CACHE_MISSING_KEY)).booleanValue()).build();
        }
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return cache;
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(JdbcConnectorOptions.URL);
        requiredOptions.add(JdbcConnectorOptions.TABLE_NAME);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(JdbcConnectorOptions.DRIVER);
        optionalOptions.add(JdbcConnectorOptions.USERNAME);
        optionalOptions.add(JdbcConnectorOptions.PASSWORD);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_COLUMN);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_NUM);
        optionalOptions.add(JdbcConnectorOptions.SCAN_FETCH_SIZE);
        optionalOptions.add(JdbcConnectorOptions.SCAN_AUTO_COMMIT);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_CACHE_TTL);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_MAX_RETRIES);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_CACHE_MISSING_KEY);
        optionalOptions.add(JdbcConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        optionalOptions.add(JdbcConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(JdbcConnectorOptions.SINK_MAX_RETRIES);
        optionalOptions.add(JdbcConnectorOptions.SINK_PARALLELISM);
        optionalOptions.add(JdbcConnectorOptions.MAX_RETRY_TIMEOUT);
        optionalOptions.add(LookupOptions.CACHE_TYPE);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_MAX_ROWS);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY);
        optionalOptions.add(LookupOptions.MAX_RETRIES);
        return optionalOptions;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(JdbcConnectorOptions.URL, JdbcConnectorOptions.TABLE_NAME, JdbcConnectorOptions.USERNAME, JdbcConnectorOptions.PASSWORD, JdbcConnectorOptions.DRIVER, JdbcConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS, JdbcConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL, JdbcConnectorOptions.SINK_MAX_RETRIES, JdbcConnectorOptions.MAX_RETRY_TIMEOUT, JdbcConnectorOptions.SCAN_FETCH_SIZE, JdbcConnectorOptions.SCAN_AUTO_COMMIT).collect(Collectors.toSet());
    }

    private void validateConfigOptions(ReadableConfig config, ClassLoader classLoader) {
        long upperBound;
        long lowerBound;
        String jdbcUrl = (String)config.get(JdbcConnectorOptions.URL);
        JdbcDialectLoader.load(jdbcUrl, classLoader);
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.USERNAME, JdbcConnectorOptions.PASSWORD});
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.SCAN_PARTITION_COLUMN, JdbcConnectorOptions.SCAN_PARTITION_NUM, JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND, JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND});
        if (config.getOptional(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND).isPresent() && config.getOptional(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND).isPresent() && (lowerBound = ((Long)config.get(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND)).longValue()) > (upperBound = ((Long)config.get(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND)).longValue())) {
            throw new IllegalArgumentException(String.format("'%s'='%s' must not be larger than '%s'='%s'.", JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND.key(), lowerBound, JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND.key(), upperBound));
        }
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS, JdbcConnectorOptions.LOOKUP_CACHE_TTL});
        if ((Integer)config.get(JdbcConnectorOptions.LOOKUP_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", JdbcConnectorOptions.LOOKUP_MAX_RETRIES.key(), config.get(JdbcConnectorOptions.LOOKUP_MAX_RETRIES)));
        }
        if ((Integer)config.get(JdbcConnectorOptions.SINK_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", JdbcConnectorOptions.SINK_MAX_RETRIES.key(), config.get(JdbcConnectorOptions.SINK_MAX_RETRIES)));
        }
        if (((Duration)config.get(JdbcConnectorOptions.MAX_RETRY_TIMEOUT)).getSeconds() <= 0L) {
            throw new IllegalArgumentException(String.format("The value of '%s' option must be in second granularity and shouldn't be smaller than 1 second, but is %s.", JdbcConnectorOptions.MAX_RETRY_TIMEOUT.key(), config.get(ConfigOptions.key((String)JdbcConnectorOptions.MAX_RETRY_TIMEOUT.key()).stringType().noDefaultValue())));
        }
    }

    private void checkAllOrNone(ReadableConfig config, ConfigOption<?>[] configOptions) {
        int presentCount = 0;
        for (ConfigOption<?> configOption : configOptions) {
            if (!config.getOptional(configOption).isPresent()) continue;
            ++presentCount;
        }
        CharSequence[] propertyNames = (String[])Arrays.stream(configOptions).map(ConfigOption::key).toArray(String[]::new);
        Preconditions.checkArgument((configOptions.length == presentCount || presentCount == 0 ? 1 : 0) != 0, (Object)("Either all or none of the following options should be provided:\n" + String.join((CharSequence)"\n", propertyNames)));
    }
}

