/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.TaskManagerOptions;

public final class ClusterSpecification {
    private final int masterMemoryMB;
    private final int taskManagerMemoryMB;
    private final int numberTaskManagers;
    private final int slotsPerTaskManager;

    private ClusterSpecification(int masterMemoryMB, int taskManagerMemoryMB, int numberTaskManagers, int slotsPerTaskManager) {
        this.masterMemoryMB = masterMemoryMB;
        this.taskManagerMemoryMB = taskManagerMemoryMB;
        this.numberTaskManagers = numberTaskManagers;
        this.slotsPerTaskManager = slotsPerTaskManager;
    }

    public int getMasterMemoryMB() {
        return this.masterMemoryMB;
    }

    public int getTaskManagerMemoryMB() {
        return this.taskManagerMemoryMB;
    }

    public int getNumberTaskManagers() {
        return this.numberTaskManagers;
    }

    public int getSlotsPerTaskManager() {
        return this.slotsPerTaskManager;
    }

    public String toString() {
        return "ClusterSpecification{masterMemoryMB=" + this.masterMemoryMB + ", taskManagerMemoryMB=" + this.taskManagerMemoryMB + ", numberTaskManagers=" + this.numberTaskManagers + ", slotsPerTaskManager=" + this.slotsPerTaskManager + '}';
    }

    public static ClusterSpecification fromConfiguration(Configuration configuration) {
        int slots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        int jobManagerMemoryMb = ConfigurationUtils.getJobManagerHeapMemory((Configuration)configuration).getMebiBytes();
        int taskManagerMemoryMb = ConfigurationUtils.getTaskManagerHeapMemory((Configuration)configuration).getMebiBytes();
        return new ClusterSpecificationBuilder().setMasterMemoryMB(jobManagerMemoryMb).setTaskManagerMemoryMB(taskManagerMemoryMb).setNumberTaskManagers(1).setSlotsPerTaskManager(slots).createClusterSpecification();
    }

    public static class ClusterSpecificationBuilder {
        private int masterMemoryMB = 768;
        private int taskManagerMemoryMB = 768;
        private int numberTaskManagers = 1;
        private int slotsPerTaskManager = 1;

        public ClusterSpecificationBuilder setMasterMemoryMB(int masterMemoryMB) {
            this.masterMemoryMB = masterMemoryMB;
            return this;
        }

        public ClusterSpecificationBuilder setTaskManagerMemoryMB(int taskManagerMemoryMB) {
            this.taskManagerMemoryMB = taskManagerMemoryMB;
            return this;
        }

        public ClusterSpecificationBuilder setNumberTaskManagers(int numberTaskManagers) {
            this.numberTaskManagers = numberTaskManagers;
            return this;
        }

        public ClusterSpecificationBuilder setSlotsPerTaskManager(int slotsPerTaskManager) {
            this.slotsPerTaskManager = slotsPerTaskManager;
            return this;
        }

        public ClusterSpecification createClusterSpecification() {
            return new ClusterSpecification(this.masterMemoryMB, this.taskManagerMemoryMB, this.numberTaskManagers, this.slotsPerTaskManager);
        }
    }
}

