/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest.retry;

import org.apache.flink.client.program.rest.retry.WaitStrategy;
import org.apache.flink.util.Preconditions;

public class ExponentialWaitStrategy
implements WaitStrategy {
    private final long initialWait;
    private final long maxWait;

    public ExponentialWaitStrategy(long initialWait, long maxWait) {
        Preconditions.checkArgument((initialWait > 0L ? 1 : 0) != 0, (String)"initialWait must be positive, was %s", (Object[])new Object[]{initialWait});
        Preconditions.checkArgument((maxWait > 0L ? 1 : 0) != 0, (String)"maxWait must be positive, was %s", (Object[])new Object[]{maxWait});
        Preconditions.checkArgument((initialWait <= maxWait ? 1 : 0) != 0, (String)"initialWait must be lower than or equal to maxWait", (Object[])new Object[]{maxWait});
        this.initialWait = initialWait;
        this.maxWait = maxWait;
    }

    @Override
    public long sleepTime(long attempt) {
        Preconditions.checkArgument((attempt >= 0L ? 1 : 0) != 0, (String)"attempt must not be negative (%d)", (Object[])new Object[]{attempt});
        long exponentialSleepTime = this.initialWait * Math.round(Math.pow(2.0, attempt));
        return exponentialSleepTime >= 0L && exponentialSleepTime < this.maxWait ? exponentialSleepTime : this.maxWait;
    }
}

