/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.deployment.application.JarManifestParser;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClassPathPackagedProgramRetriever
implements PackagedProgramRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathPackagedProgramRetriever.class);
    @Nonnull
    private final Collection<URL> userClassPaths;
    @Nonnull
    private final String[] programArguments;
    @Nullable
    private final String jobClassName;
    @Nonnull
    private final Supplier<Iterable<File>> jarsOnClassPath;
    @Nullable
    private final File userLibDirectory;
    @Nullable
    private final File jarFile;
    @Nonnull
    private final Configuration configuration;

    private ClassPathPackagedProgramRetriever(@Nonnull String[] programArguments, @Nullable String jobClassName, @Nonnull Supplier<Iterable<File>> jarsOnClassPath, @Nullable File userLibDirectory, @Nullable File jarFile, @Nonnull Configuration configuration) throws IOException {
        this.userLibDirectory = userLibDirectory;
        this.programArguments = Objects.requireNonNull(programArguments, "programArguments");
        this.jobClassName = jobClassName;
        this.jarsOnClassPath = Objects.requireNonNull(jarsOnClassPath);
        this.userClassPaths = ClassPathPackagedProgramRetriever.getUserClasspaths(configuration, userLibDirectory);
        this.jarFile = jarFile;
        this.configuration = configuration;
    }

    private static Collection<URL> getUserClasspaths(Configuration configuration, @Nullable File jobDir) throws IOException {
        Collection<URL> classpathsFromUserLibDir = ClassPathPackagedProgramRetriever.getClasspathsFromUserLibDir(jobDir);
        Collection<URL> classpathsFromConfiguration = ClassPathPackagedProgramRetriever.getClasspathsFromConfiguration(configuration);
        ArrayList<URL> classpaths = new ArrayList<URL>();
        classpaths.addAll(classpathsFromUserLibDir);
        classpaths.addAll(classpathsFromConfiguration);
        List<URL> userClasspaths = Collections.unmodifiableList(classpaths);
        return userClasspaths;
    }

    private static Collection<URL> getClasspathsFromUserLibDir(File jobDir) throws IOException {
        if (jobDir == null) {
            return Collections.emptyList();
        }
        Path workingDirectory = FileUtils.getCurrentWorkingDirectory();
        Collection relativeJarURLs = FileUtils.listFilesInDirectory((Path)jobDir.toPath(), FileUtils::isJarFile).stream().map(path -> FileUtils.relativizePath((Path)workingDirectory, (Path)path)).map(FunctionUtils.uncheckedFunction(FileUtils::toURL)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(relativeJarURLs);
    }

    private static Collection<URL> getClasspathsFromConfiguration(Configuration configuration) throws MalformedURLException {
        if (configuration == null) {
            return Collections.emptyList();
        }
        return ConfigUtils.decodeListFromConfig((ReadableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, URL::new);
    }

    @Override
    public PackagedProgram getPackagedProgram() throws FlinkException {
        try {
            if (PackagedProgramUtils.isPython(this.jobClassName).booleanValue() || PackagedProgramUtils.isPython(this.programArguments)) {
                String pythonJobClassName = PackagedProgramUtils.getPythonDriverClassName();
                File pythonJarFile = new File(PackagedProgramUtils.getPythonJar().getPath());
                return PackagedProgram.newBuilder().setUserClassPaths(new ArrayList<URL>(this.userClassPaths)).setArguments(this.programArguments).setJarFile(pythonJarFile).setEntryPointClassName(pythonJobClassName).build();
            }
            if (this.jarFile != null) {
                return PackagedProgram.newBuilder().setUserClassPaths(new ArrayList<URL>(this.userClassPaths)).setArguments(this.programArguments).setJarFile(this.jarFile).setEntryPointClassName(this.jobClassName).setConfiguration(this.configuration).build();
            }
            String entryClass = this.getJobClassNameOrScanClassPath();
            return PackagedProgram.newBuilder().setUserClassPaths(new ArrayList<URL>(this.userClassPaths)).setEntryPointClassName(entryClass).setArguments(this.programArguments).setConfiguration(this.configuration).build();
        }
        catch (ProgramInvocationException e) {
            throw new FlinkException("Could not load the provided entrypoint class.", (Throwable)e);
        }
    }

    private String getJobClassNameOrScanClassPath() throws FlinkException {
        if (this.jobClassName != null) {
            if (this.userLibDirectory != null && !this.userClassPathContainsJobClass(this.jobClassName)) {
                throw new FlinkException(String.format("Could not find the provided job class (%s) in the user lib directory (%s).", this.jobClassName, this.userLibDirectory));
            }
            return this.jobClassName;
        }
        try {
            return this.scanClassPathForJobJar();
        }
        catch (IOException | IllegalArgumentException | NoSuchElementException e) {
            throw new FlinkException("Failed to find job JAR on class path. Please provide the job class name explicitly.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userClassPathContainsJobClass(String jobClassName) {
        Iterator<URL> iterator = this.userClassPaths.iterator();
        while (iterator.hasNext()) {
            URL userClassPath = iterator.next();
            try {
                JarFile jarFile = new JarFile(userClassPath.getFile());
                Throwable throwable = null;
                try {
                    if (!this.jarContainsJobClass(jobClassName, jarFile)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e, (String)String.format("Failed to open user class path %s. Make sure that all files on the user class path can be accessed.", userClassPath));
            }
        }
        return false;
    }

    private boolean jarContainsJobClass(String jobClassName, JarFile jarFile) {
        return jarFile.stream().map(ZipEntry::getName).filter(fileName -> fileName.endsWith("class")).map(FileUtils::stripFileExtension).map(fileName -> fileName.replaceAll(Pattern.quote(File.separator), ".")).anyMatch(name -> name.equals(jobClassName));
    }

    private String scanClassPathForJobJar() throws IOException {
        Iterable jars;
        if (this.userLibDirectory == null) {
            LOG.info("Scanning system class path for job JAR");
            jars = this.jarsOnClassPath.get();
        } else {
            LOG.info("Scanning user class path for job JAR");
            jars = this.userClassPaths.stream().map(url -> new File(url.getFile())).collect(Collectors.toList());
        }
        JarManifestParser.JarFileWithEntryClass jobJar = JarManifestParser.findOnlyEntryClass(jars);
        LOG.info("Using {} as job jar", (Object)jobJar);
        return jobJar.getEntryClass();
    }

    public static Builder newBuilder(String[] programArguments, Configuration configuration) {
        return new Builder(programArguments, configuration);
    }

    public static class Builder {
        private final String[] programArguments;
        @Nullable
        private String jobClassName;
        @Nullable
        private File userLibDirectory;
        private Supplier<Iterable<File>> jarsOnClassPath = JarsOnClassPath.INSTANCE;
        private File jarFile;
        private final Configuration configuration;

        private Builder(String[] programArguments, Configuration configuration) {
            this.programArguments = Objects.requireNonNull(programArguments);
            this.configuration = Objects.requireNonNull(configuration);
        }

        public Builder setJobClassName(@Nullable String jobClassName) {
            this.jobClassName = jobClassName;
            return this;
        }

        public Builder setUserLibDirectory(File userLibDirectory) {
            this.userLibDirectory = userLibDirectory;
            return this;
        }

        public Builder setJarsOnClassPath(Supplier<Iterable<File>> jarsOnClassPath) {
            this.jarsOnClassPath = jarsOnClassPath;
            return this;
        }

        public Builder setJarFile(File file) {
            this.jarFile = file;
            return this;
        }

        public ClassPathPackagedProgramRetriever build() throws IOException {
            return new ClassPathPackagedProgramRetriever(this.programArguments, this.jobClassName, this.jarsOnClassPath, this.userLibDirectory, this.jarFile, this.configuration);
        }
    }

    @VisibleForTesting
    static enum JarsOnClassPath implements Supplier<Iterable<File>>
    {
        INSTANCE;

        static final String JAVA_CLASS_PATH = "java.class.path";
        static final String PATH_SEPARATOR = "path.separator";
        static final String DEFAULT_PATH_SEPARATOR = ":";

        @Override
        public Iterable<File> get() {
            String classPath = System.getProperty(JAVA_CLASS_PATH, "");
            String pathSeparator = System.getProperty(PATH_SEPARATOR, DEFAULT_PATH_SEPARATOR);
            return Arrays.stream(classPath.split(pathSeparator)).filter(JarsOnClassPath::notNullAndNotEmpty).map(File::new).filter(File::isFile).collect(Collectors.toList());
        }

        private static boolean notNullAndNotEmpty(String string) {
            return string != null && !string.equals("");
        }
    }
}

