/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.annotation.Nullable;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.util.Preconditions;

public class OptimizerPlanEnvironment
extends ExecutionEnvironment {
    private Pipeline pipeline;

    public JobClient executeAsync(String jobName) throws Exception {
        this.pipeline = this.createProgramPlan();
        throw new ProgramAbortException();
    }

    public Pipeline getPipeline(PackagedProgram prog, boolean suppressOutput) throws ProgramInvocationException {
        ByteArrayOutputStream stdErrBuffer;
        ByteArrayOutputStream stdOutBuffer;
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        if (suppressOutput) {
            stdOutBuffer = new ByteArrayOutputStream();
            System.setOut(new PrintStream(stdOutBuffer));
            stdErrBuffer = new ByteArrayOutputStream();
            System.setErr(new PrintStream(stdErrBuffer));
        } else {
            stdOutBuffer = null;
            stdErrBuffer = null;
        }
        this.setAsContext();
        try {
            prog.invokeInteractiveModeForExecution();
        }
        catch (ProgramInvocationException e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.pipeline != null) {
                Pipeline pipeline = this.pipeline;
                return pipeline;
            }
            throw OptimizerPlanEnvironment.generateException(prog, "The program caused an error: ", t, stdOutBuffer, stdErrBuffer);
        }
        finally {
            this.unsetAsContext();
            if (suppressOutput) {
                System.setOut(originalOut);
                System.setErr(originalErr);
            }
        }
        throw OptimizerPlanEnvironment.generateException(prog, "The program plan could not be fetched - the program aborted pre-maturely.", stdOutBuffer, stdErrBuffer);
    }

    private void setAsContext() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                return OptimizerPlanEnvironment.this;
            }
        };
        OptimizerPlanEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    private void unsetAsContext() {
        OptimizerPlanEnvironment.resetContextEnvironment();
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    private static ProgramInvocationException generateException(PackagedProgram prog, String msg, @Nullable ByteArrayOutputStream stdout, @Nullable ByteArrayOutputStream stderr) {
        return OptimizerPlanEnvironment.generateException(prog, msg, null, stdout, stderr);
    }

    private static ProgramInvocationException generateException(PackagedProgram prog, String msg, @Nullable Throwable cause, @Nullable ByteArrayOutputStream stdoutBuffer, @Nullable ByteArrayOutputStream stderrBuffer) {
        Preconditions.checkState((stdoutBuffer != null == (stderrBuffer != null) ? 1 : 0) != 0, (Object)"Stderr/Stdout should either both be set or both be null.");
        String stdout = "";
        String stderr = "";
        if (stdoutBuffer != null) {
            stdout = stdoutBuffer.toString();
            stderr = stderrBuffer.toString();
        }
        return new ProgramInvocationException(String.format("%s\n\nClasspath: %s\n\nSystem.out: %s\n\nSystem.err: %s", msg, prog.getJobJarAndDependencies(), stdout.length() == 0 ? "(none)" : stdout, stderr.length() == 0 ? "(none)" : stderr), cause);
    }

    public static final class ProgramAbortException
    extends Error {
        private static final long serialVersionUID = 1L;
    }
}

