/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.client.program.StreamPlanEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.Preconditions;

public enum PackagedProgramUtils {

    private static final String PYTHON_GATEWAY_CLASS_NAME = "org.apache.flink.client.python.PythonGatewayServer";
    private static final String PYTHON_DRIVER_CLASS_NAME = "org.apache.flink.client.python.PythonDriver";

    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism, @Nullable JobID jobID, boolean suppressOutput) throws ProgramInvocationException {
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram(packagedProgram, configuration, defaultParallelism, suppressOutput);
        JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraphUnderUserClassLoader(packagedProgram.getUserCodeClassLoader(), pipeline, configuration, defaultParallelism);
        if (jobID != null) {
            jobGraph.setJobID(jobID);
        }
        jobGraph.addJars(packagedProgram.getJobJarAndDependencies());
        jobGraph.setClasspaths(packagedProgram.getClasspaths());
        jobGraph.setSavepointRestoreSettings(packagedProgram.getSavepointSettings());
        return jobGraph;
    }

    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism, boolean suppressOutput) throws ProgramInvocationException {
        return PackagedProgramUtils.createJobGraph(packagedProgram, configuration, defaultParallelism, null, suppressOutput);
    }

    public static Pipeline getPipelineFromProgram(PackagedProgram program, Configuration configuration, int parallelism, boolean suppressOutput) throws CompilerException, ProgramInvocationException {
        ByteArrayOutputStream stdErrBuffer;
        ByteArrayOutputStream stdOutBuffer;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(program.getUserCodeClassLoader());
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        if (suppressOutput) {
            stdOutBuffer = new ByteArrayOutputStream();
            System.setOut(new PrintStream(stdOutBuffer));
            stdErrBuffer = new ByteArrayOutputStream();
            System.setErr(new PrintStream(stdErrBuffer));
        } else {
            stdOutBuffer = null;
            stdErrBuffer = null;
        }
        OptimizerPlanEnvironment benv = new OptimizerPlanEnvironment(configuration, program.getUserCodeClassLoader(), parallelism);
        benv.setAsContext();
        StreamPlanEnvironment senv = new StreamPlanEnvironment(configuration, program.getUserCodeClassLoader(), parallelism);
        senv.setAsContext();
        try {
            program.invokeInteractiveModeForExecution();
        }
        catch (Throwable t) {
            if (benv.getPipeline() != null) {
                Pipeline pipeline = benv.getPipeline();
                return pipeline;
            }
            if (senv.getPipeline() != null) {
                Pipeline pipeline = senv.getPipeline();
                return pipeline;
            }
            if (t instanceof ProgramInvocationException) {
                throw t;
            }
            throw PackagedProgramUtils.generateException(program, "The program caused an error: ", t, stdOutBuffer, stdErrBuffer);
        }
        finally {
            benv.unsetAsContext();
            senv.unsetAsContext();
            if (suppressOutput) {
                System.setOut(originalOut);
                System.setErr(originalErr);
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        throw PackagedProgramUtils.generateException(program, "The program plan could not be fetched - the program aborted pre-maturely. The root cause may be that the main method doesn't call `env.execute()` or `env.executeAsync()`.", null, stdOutBuffer, stdErrBuffer);
    }

    public static Boolean isPython(String entryPointClassName) {
        return entryPointClassName != null && (entryPointClassName.equals(PYTHON_DRIVER_CLASS_NAME) || entryPointClassName.equals(PYTHON_GATEWAY_CLASS_NAME));
    }

    public static boolean isPython(String[] programArguments) {
        return CollectionUtils.containsAny(Arrays.asList(programArguments), Arrays.asList("-py", "-pym", "--python", "--pyModule"));
    }

    public static URL getPythonJar() {
        String flinkOptPath = System.getenv("FLINK_OPT_DIR");
        final ArrayList pythonJarPath = new ArrayList();
        try {
            Files.walkFileTree(FileSystems.getDefault().getPath(flinkOptPath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult result = super.visitFile(file, attrs);
                    if (file.getFileName().toString().startsWith("flink-python")) {
                        pythonJarPath.add(file);
                    }
                    return result;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encountered during finding the flink-python jar. This should not happen.", e);
        }
        if (pythonJarPath.size() != 1) {
            throw new RuntimeException("Found " + pythonJarPath.size() + " flink-python jar.");
        }
        try {
            return ((Path)pythonJarPath.get(0)).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL is invalid. This should not happen.", e);
        }
    }

    public static String getPythonDriverClassName() {
        return PYTHON_DRIVER_CLASS_NAME;
    }

    public static URI resolveURI(String path) throws URISyntaxException {
        URI uri = new URI(path);
        if (uri.getScheme() != null) {
            return uri;
        }
        return new File(path).getAbsoluteFile().toURI();
    }

    private static ProgramInvocationException generateException(PackagedProgram program, String msg, @Nullable Throwable cause, @Nullable ByteArrayOutputStream stdoutBuffer, @Nullable ByteArrayOutputStream stderrBuffer) {
        Preconditions.checkState((stdoutBuffer != null == (stderrBuffer != null) ? 1 : 0) != 0, (Object)"Stderr/Stdout should either both be set or both be null.");
        String stdout = stdoutBuffer != null ? stdoutBuffer.toString() : "";
        String stderr = stderrBuffer != null ? stderrBuffer.toString() : "";
        return new ProgramInvocationException(String.format("%s\n\nClasspath: %s\n\nSystem.out: %s\n\nSystem.err: %s", msg, program.getJobJarAndDependencies(), stdout.length() == 0 ? "(none)" : stdout, stderr.length() == 0 ? "(none)" : stderr), cause);
    }
}

