/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslator;
import org.apache.flink.client.PlanTranslator;
import org.apache.flink.client.StreamGraphTranslator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;

public final class FlinkPipelineTranslationUtil {
    public static JobGraph getJobGraph(ClassLoader userClassloader, Pipeline pipeline, Configuration optimizerConfiguration, int defaultParallelism) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(userClassloader, pipeline);
        JobGraph jobGraph = pipelineTranslator.translateToJobGraph(pipeline, optimizerConfiguration, defaultParallelism);
        optimizerConfiguration.getOptional(PipelineOptions.PARALLELISM_OVERRIDES).ifPresent(map -> jobGraph.getJobConfiguration().set(PipelineOptions.PARALLELISM_OVERRIDES, map));
        return jobGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobGraph getJobGraphUnderUserClassLoader(ClassLoader userClassloader, Pipeline pipeline, Configuration configuration, int defaultParallelism) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userClassloader);
            JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraph(userClassloader, pipeline, configuration, defaultParallelism);
            return jobGraph;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static String translateToJSONExecutionPlan(ClassLoader userClassloader, Pipeline pipeline) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(userClassloader, pipeline);
        return pipelineTranslator.translateToJSONExecutionPlan(pipeline);
    }

    private static FlinkPipelineTranslator getPipelineTranslator(ClassLoader userClassloader, Pipeline pipeline) {
        PlanTranslator planTranslator = new PlanTranslator();
        if (planTranslator.canTranslate(pipeline)) {
            return planTranslator;
        }
        StreamGraphTranslator streamGraphTranslator = new StreamGraphTranslator(userClassloader);
        if (streamGraphTranslator.canTranslate(pipeline)) {
            return streamGraphTranslator;
        }
        throw new RuntimeException("Translator " + streamGraphTranslator + " cannot translate the given pipeline " + pipeline + ".");
    }
}

