/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistrationSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.util.Preconditions;

public class BackwardsCompatibleAvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private TypeSerializer<T> serializer;

    public BackwardsCompatibleAvroSerializer(Class<T> type) {
        this.type = type;
        this.serializer = new AvroSerializer<T>(type);
    }

    private BackwardsCompatibleAvroSerializer(Class<T> type, TypeSerializer<T> serializer) {
        this.type = type;
        this.serializer = serializer;
    }

    public boolean isImmutableType() {
        return this.serializer.isImmutableType();
    }

    public int getLength() {
        return this.serializer.getLength();
    }

    public T createInstance() {
        return (T)this.serializer.createInstance();
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        this.serializer.serialize(value, target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return (T)this.serializer.deserialize(source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.serializer.deserialize(reuse, source);
    }

    public T copy(T from) {
        return (T)this.serializer.copy(from);
    }

    public T copy(T from, T reuse) {
        return (T)this.serializer.copy(from, reuse);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serializer.copy(source, target);
    }

    public TypeSerializer<T> duplicate() {
        return new BackwardsCompatibleAvroSerializer<T>(this.type, this.serializer.duplicate());
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == BackwardsCompatibleAvroSerializer.class) {
            BackwardsCompatibleAvroSerializer that = (BackwardsCompatibleAvroSerializer)((Object)obj);
            return this.type == that.type && this.serializer.equals(that.serializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (" + this.type.getName() + ')';
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return this.serializer.snapshotConfiguration();
    }

    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof AvroSerializer.AvroSchemaSerializerConfigSnapshot || configSnapshot instanceof AvroSerializer.AvroSerializerConfigSnapshot) {
            Preconditions.checkState((boolean)(this.serializer instanceof AvroSerializer), (Object)"Serializer was changed backwards to PojoSerializer and now encounters AvroSerializer snapshot.");
            return this.serializer.ensureCompatibility(configSnapshot);
        }
        if (configSnapshot instanceof PojoSerializer.PojoSerializerConfigSnapshot) {
            PojoSerializer pojoSerializer;
            Preconditions.checkState((boolean)SpecificRecordBase.class.isAssignableFrom(this.type), (Object)"BackwardsCompatibleAvroSerializer resuming a state serialized via a PojoSerializer, but not for an Avro Specific Record");
            AvroTypeInfo<SpecificRecordBase> typeInfo = new AvroTypeInfo<SpecificRecordBase>(this.type.asSubclass(SpecificRecordBase.class), true);
            this.serializer = pojoSerializer = typeInfo.createPojoSerializer(new ExecutionConfig());
            return this.serializer.ensureCompatibility(configSnapshot);
        }
        if (configSnapshot instanceof KryoRegistrationSerializerConfigSnapshot) {
            this.serializer = new KryoSerializer(this.type, new ExecutionConfig());
            return this.serializer.ensureCompatibility(configSnapshot);
        }
        return CompatibilityResult.requiresMigration();
    }
}

