/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.BackwardsCompatibleAvroSerializer;

public class AvroTypeInfo<T extends SpecificRecordBase>
extends PojoTypeInfo<T> {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentHashMap<Thread, Boolean> IN_BACKWARDS_COMPATIBLE_MODE = new ConcurrentHashMap();
    private final boolean useBackwardsCompatibleSerializer;

    public AvroTypeInfo(Class<T> typeClass) {
        this(typeClass, false);
    }

    public AvroTypeInfo(Class<T> typeClass, boolean useBackwardsCompatibleSerializer) {
        super(typeClass, AvroTypeInfo.generateFieldsFromAvroSchema(typeClass, useBackwardsCompatibleSerializer));
        Boolean modeOnStack = IN_BACKWARDS_COMPATIBLE_MODE.get(Thread.currentThread());
        this.useBackwardsCompatibleSerializer = modeOnStack == null ? useBackwardsCompatibleSerializer : modeOnStack;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.useBackwardsCompatibleSerializer ? new BackwardsCompatibleAvroSerializer(this.getTypeClass()) : new AvroSerializer(this.getTypeClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static <T extends SpecificRecordBase> List<PojoField> generateFieldsFromAvroSchema(Class<T> typeClass, boolean useBackwardsCompatibleSerializer) {
        Thread currentThread = Thread.currentThread();
        boolean entryPoint = IN_BACKWARDS_COMPATIBLE_MODE.putIfAbsent(currentThread, useBackwardsCompatibleSerializer) == null;
        try {
            PojoTypeExtractor pte = new PojoTypeExtractor();
            ArrayList<Type> typeHierarchy = new ArrayList<Type>();
            typeHierarchy.add(typeClass);
            TypeInformation<T> ti = pte.analyzePojo(typeClass, typeHierarchy, null, null, null);
            if (!(ti instanceof PojoTypeInfo)) {
                throw new IllegalStateException("Expecting type to be a PojoTypeInfo");
            }
            PojoTypeInfo pti = (PojoTypeInfo)ti;
            ArrayList<PojoField> newFields = new ArrayList<PojoField>(pti.getTotalFields());
            for (int i = 0; i < pti.getArity(); ++i) {
                PojoField f = pti.getPojoFieldAt(i);
                TypeInformation newType = f.getTypeInformation();
                if (newType instanceof GenericTypeInfo && newType.getTypeClass().equals(CharSequence.class)) {
                    newType = new GenericTypeInfo(Utf8.class);
                }
                PojoField newField = new PojoField(f.getField(), newType);
                newFields.add(newField);
            }
            ArrayList<PojoField> arrayList = newFields;
            return arrayList;
        }
        finally {
            if (entryPoint) {
                IN_BACKWARDS_COMPATIBLE_MODE.remove(currentThread);
            }
        }
    }

    private static class PojoTypeExtractor
    extends TypeExtractor {
        private PojoTypeExtractor() {
        }

        public <OUT, IN1, IN2> TypeInformation<OUT> analyzePojo(Class<OUT> clazz, ArrayList<Type> typeHierarchy, ParameterizedType parameterizedType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
            return super.analyzePojo(clazz, typeHierarchy, parameterizedType, in1Type, in2Type);
        }
    }
}

