/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistrationSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

@Deprecated
@Internal
public final class AvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final Class<? extends T> typeToInstantiate;
    private LinkedHashMap<String, KryoRegistration> kryoRegistrations;
    private transient ReflectDatumWriter<T> writer;
    private transient ReflectDatumReader<T> reader;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient Kryo kryo;
    private transient T deepCopyInstance;

    public AvroSerializer(Class<T> type) {
        this(type, type);
    }

    public AvroSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        this.type = (Class)Preconditions.checkNotNull(type);
        this.typeToInstantiate = (Class)Preconditions.checkNotNull(typeToInstantiate);
        InstantiationUtil.checkForInstantiation(typeToInstantiate);
        this.kryoRegistrations = AvroSerializer.buildKryoRegistrations(type);
    }

    public boolean isImmutableType() {
        return false;
    }

    public AvroSerializer<T> duplicate() {
        return new AvroSerializer<T>(this.type, this.typeToInstantiate);
    }

    public T createInstance() {
        return (T)InstantiationUtil.instantiate(this.typeToInstantiate);
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)KryoUtils.copy(from, (Kryo)this.kryo, (TypeSerializer)this);
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)KryoUtils.copy(from, reuse, (Kryo)this.kryo, (TypeSerializer)this);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        this.encoder.setOut((DataOutput)target);
        this.writer.write(value, (Encoder)this.encoder);
    }

    public T deserialize(DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn((DataInput)source);
        return (T)this.reader.read(null, (Decoder)this.decoder);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn((DataInput)source);
        return (T)this.reader.read(reuse, (Decoder)this.decoder);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        if (this.deepCopyInstance == null) {
            this.deepCopyInstance = InstantiationUtil.instantiate(this.type, Object.class);
        }
        this.decoder.setIn((DataInput)source);
        this.encoder.setOut((DataOutput)target);
        Object tmp = this.reader.read(this.deepCopyInstance, (Decoder)this.decoder);
        this.writer.write(tmp, (Encoder)this.encoder);
    }

    private void checkAvroInitialized() {
        if (this.reader == null) {
            this.reader = new ReflectDatumReader(this.type);
            this.writer = new ReflectDatumWriter(this.type);
            this.encoder = new DataOutputEncoder();
            this.decoder = new DataInputDecoder();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            KryoUtils.applyRegistrations((Kryo)this.kryo, this.kryoRegistrations.values());
        }
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.typeToInstantiate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AvroSerializer) {
            AvroSerializer avroSerializer = (AvroSerializer)((Object)obj);
            return avroSerializer.canEqual((Object)this) && this.type == avroSerializer.type && this.typeToInstantiate == avroSerializer.typeToInstantiate;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof AvroSerializer;
    }

    public AvroSerializerConfigSnapshot<T> snapshotConfiguration() {
        return new AvroSerializerConfigSnapshot<T>(this.type, this.typeToInstantiate, this.kryoRegistrations);
    }

    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        AvroSerializerConfigSnapshot config;
        if (configSnapshot instanceof AvroSerializerConfigSnapshot && this.type.equals((config = (AvroSerializerConfigSnapshot)configSnapshot).getTypeClass()) && this.typeToInstantiate.equals(config.getTypeToInstantiate())) {
            LinkedHashMap oldRegistrations = config.getKryoRegistrations();
            oldRegistrations.putAll(this.kryoRegistrations);
            for (Map.Entry<String, KryoRegistration> reconfiguredRegistrationEntry : this.kryoRegistrations.entrySet()) {
                if (!reconfiguredRegistrationEntry.getValue().isDummy()) continue;
                return CompatibilityResult.requiresMigration();
            }
            this.kryoRegistrations = oldRegistrations;
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.kryoRegistrations == null) {
            this.kryoRegistrations = AvroSerializer.buildKryoRegistrations(this.type);
        }
    }

    private static <T> LinkedHashMap<String, KryoRegistration> buildKryoRegistrations(Class<T> serializedDataType) {
        LinkedHashMap<String, KryoRegistration> registrations = new LinkedHashMap<String, KryoRegistration>();
        registrations.put(GenericData.Array.class.getName(), new KryoRegistration(GenericData.Array.class, new ExecutionConfig.SerializableSerializer((Serializer)new Serializers.SpecificInstanceCollectionSerializerForArrayList())));
        registrations.put(Utf8.class.getName(), new KryoRegistration(Utf8.class));
        registrations.put(GenericData.EnumSymbol.class.getName(), new KryoRegistration(GenericData.EnumSymbol.class));
        registrations.put(GenericData.Fixed.class.getName(), new KryoRegistration(GenericData.Fixed.class));
        registrations.put(GenericData.StringType.class.getName(), new KryoRegistration(GenericData.StringType.class));
        registrations.put(serializedDataType.getName(), new KryoRegistration(serializedDataType));
        return registrations;
    }

    public static class AvroSerializerConfigSnapshot<T>
    extends KryoRegistrationSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;
        private Class<? extends T> typeToInstantiate;

        public AvroSerializerConfigSnapshot() {
        }

        public AvroSerializerConfigSnapshot(Class<T> baseType, Class<? extends T> typeToInstantiate, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
            super(baseType, kryoRegistrations);
            this.typeToInstantiate = (Class)Preconditions.checkNotNull(typeToInstantiate);
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.typeToInstantiate.getName());
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            String classname = in.readUTF();
            try {
                this.typeToInstantiate = Class.forName(classname, true, this.getUserCodeClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Cannot find requested class " + classname + " in classpath.", e);
            }
        }

        public int getVersion() {
            return 1;
        }

        public Class<? extends T> getTypeToInstantiate() {
            return this.typeToInstantiate;
        }
    }
}

