/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.flink.types.Row;

public class AvroConversions {
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();

    public static GenericRecord convertRowToAvroRecord(Schema schema, Row row) {
        List fields = schema.getFields();
        int length = fields.size();
        GenericData.Record record = new GenericData.Record(schema);
        for (int i = 0; i < length; ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            record.put(i, AvroConversions.convertFlinkType(field.schema(), row.getField(i)));
        }
        return record;
    }

    private static Object convertFlinkType(Schema schema, Object object) {
        if (object == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                if (object instanceof Row) {
                    return AvroConversions.convertRowToAvroRecord(schema, (Row)object);
                }
                throw new IllegalStateException("Row expected but was: " + object.getClass());
            }
            case ENUM: {
                return new GenericData.EnumSymbol(schema, object.toString());
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                Object[] array = (Object[])object;
                GenericData.Array convertedArray = new GenericData.Array(array.length, schema);
                for (Object element : array) {
                    convertedArray.add(AvroConversions.convertFlinkType(elementSchema, element));
                }
                return convertedArray;
            }
            case MAP: {
                Map map = (Map)object;
                HashMap<Utf8, Object> convertedMap = new HashMap<Utf8, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(new Utf8(entry.getKey().toString()), AvroConversions.convertFlinkType(schema.getValueType(), entry.getValue()));
                }
                return convertedMap;
            }
            case UNION: {
                Schema actualSchema;
                List types = schema.getTypes();
                int size = types.size();
                if (size == 2 && ((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)types.get(1);
                } else if (size == 2 && ((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)types.get(0);
                } else if (size == 1) {
                    actualSchema = (Schema)types.get(0);
                } else {
                    return object;
                }
                return AvroConversions.convertFlinkType(actualSchema, object);
            }
            case FIXED: {
                if (object instanceof BigDecimal) {
                    return new GenericData.Fixed(schema, AvroConversions.convertFromDecimal(schema, (BigDecimal)object));
                }
                return new GenericData.Fixed(schema, (byte[])object);
            }
            case STRING: {
                return new Utf8(object.toString());
            }
            case BYTES: {
                if (object instanceof BigDecimal) {
                    return ByteBuffer.wrap(AvroConversions.convertFromDecimal(schema, (BigDecimal)object));
                }
                return ByteBuffer.wrap((byte[])object);
            }
            case INT: {
                if (object instanceof Date) {
                    return AvroConversions.convertFromDate(schema, (Date)object);
                }
                if (object instanceof LocalDate) {
                    return AvroConversions.convertFromDate(schema, Date.valueOf((LocalDate)object));
                }
                if (object instanceof Time) {
                    return AvroConversions.convertFromTimeMillis(schema, (Time)object);
                }
                if (object instanceof LocalTime) {
                    return AvroConversions.convertFromTimeMillis(schema, Time.valueOf((LocalTime)object));
                }
                return object;
            }
            case LONG: {
                if (object instanceof Timestamp) {
                    return AvroConversions.convertFromTimestamp(schema, (Timestamp)object);
                }
                if (object instanceof LocalDateTime) {
                    return AvroConversions.convertFromTimestamp(schema, Timestamp.valueOf((LocalDateTime)object));
                }
                if (object instanceof Time) {
                    return AvroConversions.convertFromTimeMicros(schema, (Time)object);
                }
                return object;
            }
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return object;
            }
        }
        throw new RuntimeException("Unsupported Avro type:" + schema);
    }

    private static byte[] convertFromDecimal(Schema schema, BigDecimal decimal) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
            BigDecimal rescaled = decimal.setScale(decimalType.getScale(), 7);
            return decimal.unscaledValue().toByteArray();
        }
        throw new RuntimeException("Unsupported decimal type.");
    }

    private static int convertFromDate(Schema schema, Date date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.date()) {
            long converted = AvroConversions.toEpochMillis(date);
            return (int)(converted / 86400000L);
        }
        throw new RuntimeException("Unsupported date type.");
    }

    private static int convertFromTimeMillis(Schema schema, Time date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timeMillis()) {
            long converted = AvroConversions.toEpochMillis(date);
            return (int)(converted % 86400000L);
        }
        throw new RuntimeException("Unsupported time type.");
    }

    private static long convertFromTimeMicros(Schema schema, Time date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timeMicros()) {
            long converted = AvroConversions.toEpochMillis(date);
            return converted % 86400000L * 1000L;
        }
        throw new RuntimeException("Unsupported time type.");
    }

    private static long convertFromTimestamp(Schema schema, Timestamp date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timestampMillis()) {
            long time = date.getTime();
            return time + (long)LOCAL_TZ.getOffset(time);
        }
        if (logicalType == LogicalTypes.timestampMicros()) {
            long millis = date.getTime();
            long micros = millis * 1000L + (long)(date.getNanos() % 1000000 / 1000);
            long offset = (long)LOCAL_TZ.getOffset(millis) * 1000L;
            return micros + offset;
        }
        throw new RuntimeException("Unsupported timestamp type.");
    }

    private static long toEpochMillis(java.util.Date date) {
        long time = date.getTime();
        return time + (long)LOCAL_TZ.getOffset(time);
    }
}

