/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SingleRefPair<S, T>
extends RefPair<S, T> {
    private final AtomicReference<T> serviceObjectRef = new AtomicReference();

    public SingleRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public T getServiceObject(ComponentContextImpl<S> key) {
        return this.serviceObjectRef.get();
    }

    @Override
    public boolean setServiceObject(ComponentContextImpl<S> key, T serviceObject) {
        boolean set = this.serviceObjectRef.compareAndSet(null, serviceObject);
        if (serviceObject != null) {
            this.failed = false;
        }
        return set;
    }

    @Override
    public T ungetServiceObject(ComponentContextImpl<S> key) {
        return null;
    }

    @Override
    public void ungetServiceObjects(BundleContext bundleContext) {
        Object service = this.serviceObjectRef.getAndSet(null);
        if (service != null && bundleContext != null) {
            bundleContext.ungetService(this.getRef());
        }
    }

    public String toString() {
        return "[RefPair: ref: [" + this.getRef() + "] service: [" + this.serviceObjectRef.get() + "]]";
    }

    @Override
    public boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context) {
        Object service = context.getService(this.getRef());
        if (service == null) {
            this.setFailed();
            key.getLogger().log(2, "Could not get service from ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            context.ungetService(this.getRef());
        }
        return true;
    }
}

