/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.scr.impl.config.ScrConfigurationImpl;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.runtime.ServiceComponentRuntimeImpl;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractExtender
implements SimpleLogger {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    private ScrConfigurationImpl m_configuration = new ScrConfigurationImpl(this);
    private BundleContext m_context;
    private BundleContext m_globalContext;
    private Bundle m_bundle;
    private volatile ServiceTracker<LogService, LogService> m_logService;
    private Map<Long, BundleComponentActivator> m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    private ServiceRegistration<?> m_runtime_reg;
    private ScrCommand m_scrCommand;
    private volatile boolean gogoMissing = true;

    public Activator() {
        this.setSynchronous(true);
    }

    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_logService = new ServiceTracker(this.m_context, LOGSERVICE_CLASS, null);
        this.m_logService.open();
        ClassUtils.setBundleContext(context);
        this.m_configuration.start(this.m_context);
    }

    public void restart(boolean globalExtender) {
        BundleContext context = this.m_globalContext;
        this.m_globalContext = globalExtender ? this.m_context.getBundle("System Bundle").getBundleContext() : this.m_context;
        if (ClassUtils.m_packageAdmin != null) {
            this.log(3, this.m_bundle, "Stopping to restart with new globalExtender setting: " + globalExtender, null);
            try {
                super.stop(context);
            }
            catch (Exception e) {
                this.log(1, this.m_bundle, "Exception stopping during restart", (Throwable)e);
            }
        }
        try {
            this.log(3, this.m_bundle, "Starting with globalExtender setting: " + globalExtender, null);
            super.start(this.m_globalContext);
        }
        catch (Exception e) {
            this.log(1, this.m_bundle, "Exception starting during restart", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        this.m_componentBundles = new HashMap<Long, BundleComponentActivator>();
        this.m_componentRegistry = new ComponentRegistry(this);
        ServiceComponentRuntimeImpl runtime = new ServiceComponentRuntimeImpl(this.m_globalContext, this.m_componentRegistry);
        this.m_runtime_reg = this.m_context.registerService(ServiceComponentRuntime.class, (Object)runtime, null);
        this.log(3, this.m_bundle, " Version = {0}", new Object[]{this.m_bundle.getHeaders().get("Bundle-Version")}, null);
        this.m_componentActor = new ComponentActorThread(this);
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        super.doStart();
        this.m_scrCommand = ScrCommand.register(this.m_context, runtime, this.m_configuration);
        this.m_configuration.setScrCommand(this.m_scrCommand);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.m_configuration.stop();
        this.m_configuration = null;
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.m_scrCommand != null) {
            this.m_scrCommand.unregister();
            this.m_scrCommand = null;
        }
        if (this.m_runtime_reg != null) {
            this.m_runtime_reg.unregister();
            this.m_runtime_reg = null;
        }
        if (this.m_componentRegistry != null) {
            this.m_componentRegistry = null;
        }
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        if (this.m_logService != null) {
            this.m_logService.close();
            this.m_logService = null;
        }
        ClassUtils.close();
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        if (this.gogoMissing) {
            try {
                bundle.loadClass("org.apache.felix.service.command.Descriptor");
                this.gogoMissing = false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ScrExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            this.log(4, this.m_bundle, "Cannot get BundleContext of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List extenderWires = wiring.getRequiredWires("osgi.extender");
        try {
            for (BundleWire wire : extenderWires) {
                if (!"osgi.component".equals(wire.getCapability().getAttributes().get("osgi.extender"))) continue;
                if (((BundleRevision)this.m_bundle.adapt(BundleRevision.class)).equals(wire.getProvider())) break;
                this.log(4, this.m_bundle, "Bundle {0}/{1} wired to a different extender: {2}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), wire.getProvider().getSymbolicName()}, null);
                return;
            }
        }
        catch (NoSuchMethodError e) {
            this.log(4, this.m_bundle, "Cannot determine bundle wiring on pre R6 framework", null, null);
        }
        Long bundleId = bundle.getBundleId();
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, null);
                loaded = false;
            }
        }
        if (loaded) {
            this.log(4, this.m_bundle, "Components for bundle {0}/{1} already loaded. Nothing to do.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this, this.m_componentRegistry, this.m_componentActor, context, this.m_configuration);
            ga.initialEnable();
            Map<Long, BundleComponentActivator> map2 = this.m_componentBundles;
            synchronized (map2) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map<Long, BundleComponentActivator> map3 = this.m_componentBundles;
            synchronized (map3) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                this.log(4, this.m_bundle, "Bundle {0}/{1} has been stopped while trying to activate its components. Trying again when the bundles gets started again.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
            this.log(1, this.m_bundle, "Error while loading components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga;
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(bundle.getBundleId());
        }
        if (ga != null) {
            try {
                int reason = this.isStopping() ? 5 : 6;
                ga.dispose(reason);
            }
            catch (Exception e) {
                this.log(1, this.m_bundle, "Error while disposing components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
        }
    }

    protected void debug(Bundle bundle, String msg) {
        String message = MessageFormat.format(msg + " bundle: {0}/{1}", bundle.getSymbolicName(), bundle.getBundleId());
        this.log(4, bundle, message, null);
    }

    protected void warn(Bundle bundle, String msg, Throwable t) {
        String message = MessageFormat.format(msg + " bundle: {0}/{1}", bundle.getSymbolicName(), bundle.getBundleId());
        this.log(2, bundle, message, t);
    }

    protected void error(String msg, Throwable t) {
        this.log(4, this.m_bundle, msg, t);
    }

    public void log(int level, String message, Throwable ex) {
        this.log(level, null, message, ex);
    }

    public void log(int level, String pattern, Object[] arguments, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, null, message, ex);
        }
    }

    public void log(int level, Bundle bundle, String pattern, Object[] arguments, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, bundle, message, ex);
        }
    }

    public boolean isLogEnabled(int level) {
        return this.m_configuration == null || this.m_configuration.getLogLevel() >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, Bundle bundle, String message, Throwable ex) {
        if (this.isLogEnabled(level)) {
            LogService logger;
            ServiceTracker<LogService, LogService> t = this.m_logService;
            LogService logService = logger = t != null ? (LogService)t.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                logger.log(level, message, ex);
            }
        }
    }

    protected class ScrExtension
    implements Extension {
        private final Bundle bundle;
        private final Lock stateLock = new ReentrantLock();

        public ScrExtension(Bundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.log(2, Activator.this.m_bundle, "The wait for bundle {0}/{1} being destroyed before starting has been interrupted.", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId()}, e);
                }
                Activator.this.loadComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.log(2, Activator.this.m_bundle, "The wait for bundle {0}/{1} being started before destruction has been interrupted.", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId()}, e);
                }
                Activator.this.disposeComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }
    }
}

