/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public abstract class StreamBackingStoreImpl
implements BackingStore {
    protected final BundleContext bundleContext;

    public StreamBackingStoreImpl(BundleContext context) {
        this.bundleContext = context;
    }

    protected abstract void checkAccess() throws BackingStoreException;

    protected abstract OutputStream getOutputStream(PreferencesDescription var1) throws IOException;

    public void store(PreferencesImpl prefs) throws BackingStoreException {
        if (!this.hasChanges(prefs)) {
            return;
        }
        this.checkAccess();
        PreferencesImpl savedData = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        if (savedData != null) {
            PreferencesImpl n = savedData.getOrCreateNode(prefs.absolutePath());
            n.applyChanges(prefs);
            prefs = n;
        }
        PreferencesImpl root = prefs.getRoot();
        try {
            OutputStream os = this.getOutputStream(root.getDescription());
            this.write(root, os);
            os.close();
        }
        catch (IOException ioe) {
            throw new BackingStoreException("Unable to store preferences.", ioe);
        }
    }

    protected boolean hasChanges(PreferencesImpl prefs) {
        if (prefs.getChangeSet().hasChanges()) {
            return true;
        }
        Iterator i = prefs.getChildren().iterator();
        while (i.hasNext()) {
            PreferencesImpl current = (PreferencesImpl)i.next();
            if (!this.hasChanges(current)) continue;
            return true;
        }
        return false;
    }

    public void update(PreferencesImpl prefs) throws BackingStoreException {
        PreferencesImpl root = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        if (root != null && root.nodeExists(prefs.absolutePath())) {
            PreferencesImpl updated = (PreferencesImpl)root.node(prefs.absolutePath());
            prefs.update(updated);
        }
    }

    protected void write(PreferencesImpl prefs, OutputStream os) throws IOException {
        this.writePreferences(prefs, os);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        Collection children = prefs.getChildren();
        oos.writeInt(children.size());
        oos.flush();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            PreferencesImpl child = (PreferencesImpl)i.next();
            byte[] name = child.name().getBytes("utf-8");
            oos.writeInt(name.length);
            oos.write(name);
            oos.flush();
            this.write(child, os);
        }
    }

    protected void read(PreferencesImpl prefs, InputStream is) throws IOException {
        this.readPreferences(prefs, is);
        ObjectInputStream ois = new ObjectInputStream(is);
        int numberOfChilren = ois.readInt();
        for (int i = 0; i < numberOfChilren; ++i) {
            int length = ois.readInt();
            byte[] name = new byte[length];
            ois.readFully(name);
            PreferencesImpl impl = (PreferencesImpl)prefs.node(new String(name, "utf-8"));
            this.read(impl, is);
        }
    }

    protected void readPreferences(PreferencesImpl prefs, InputStream in) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(in);
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            int keyLength = ois.readInt();
            int valueLength = ois.readInt();
            byte[] key = new byte[keyLength];
            byte[] value = new byte[valueLength];
            ois.readFully(key);
            ois.readFully(value);
            prefs.getProperties().put(new String(key, "utf-8"), new String(value, "utf-8"));
        }
    }

    protected void writePreferences(PreferencesImpl prefs, OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        int size = prefs.getProperties().size();
        oos.writeInt(size);
        Iterator i = prefs.getProperties().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            byte[] key = entry.getKey().toString().getBytes("utf-8");
            byte[] value = entry.getValue().toString().getBytes("utf-8");
            oos.writeInt(key.length);
            oos.writeInt(value.length);
            oos.write(key);
            oos.write(value);
        }
        oos.flush();
    }
}

