/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;
    private static final Version endMatchVersion = new Version(1, 5, 0);

    private Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(objectClass=" + clazz.toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(final BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        Version frameworkVersion = (Version)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String version = context.getProperty("org.osgi.framework.version");
                return version == null ? Version.emptyVersion : new Version(version);
            }
        });
        boolean endMatchSupported = frameworkVersion.compareTo(endMatchVersion) >= 0;
        this.listenerFilter = endMatchSupported ? ((Object)filter).toString() : null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices) {
        Tracked t;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = trackAllServices ? new AllTracked() : new Tracked();
            synchronized (tracked) {
                try {
                    this.context.addServiceListener(t, this.listenerFilter);
                    Object[] references = null;
                    if (this.trackClass != null) {
                        references = this.getInitialReferences(trackAllServices, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            references = new ServiceReference[]{this.trackReference};
                        }
                    } else {
                        references = this.getInitialReferences(trackAllServices, null, this.listenerFilter != null ? this.listenerFilter : ((Object)this.filter).toString());
                    }
                    t.setInitial(references);
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage(), e);
                }
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    private ServiceReference[] getInitialReferences(boolean trackAllServices, String className, String filterString) throws InvalidSyntaxException {
        if (trackAllServices) {
            return this.context.getAllServiceReferences(className, filterString);
        }
        return this.context.getServiceReferences(className, filterString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceReference[] references;
        Tracked outgoing;
        Object object = this;
        synchronized (object) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            outgoing.close();
            references = this.getServiceReferences();
            this.tracked = null;
            try {
                this.context.removeServiceListener(outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.modified();
        object = outgoing;
        synchronized (object) {
            outgoing.notifyAll();
        }
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                outgoing.untrack(references[i], null);
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked t = this.tracked();
            if (t == null) {
                return null;
            }
            Tracked tracked = t;
            synchronized (tracked) {
                if (t.size() == 0) {
                    t.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return (ServiceReference[])t.getTracked(new ServiceReference[length]);
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            for (int i = 0; i < length; ++i) {
                int ranking;
                Object property = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                    continue;
                }
                if (ranking != maxRanking) continue;
                ++count;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    long id;
                    if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                    index = i;
                    minId = id;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(reference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked() {
        }
    }

    class Tracked
    extends AbstractTracked
    implements ServiceListener {
        Tracked() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(reference, event);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        this.track(reference, event);
                        break;
                    }
                    this.untrack(reference, event);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event);
                }
            }
        }

        void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        Object customizerAdding(Object item, Object related) {
            return ServiceTracker.this.customizer.addingService((ServiceReference)item);
        }

        void customizerModified(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.modifiedService((ServiceReference)item, object);
        }

        void customizerRemoved(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.removedService((ServiceReference)item, object);
        }
    }
}

