/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.jmx;

import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Properties;
import javax.management.DynamicMBean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.jmx.DynamicMBeanImpl;
import org.apache.felix.ipojo.handlers.jmx.DynamicMBeanWRegisterImpl;
import org.apache.felix.ipojo.handlers.jmx.JMXHandlerDescription;
import org.apache.felix.ipojo.handlers.jmx.JmxConfigFieldMap;
import org.apache.felix.ipojo.handlers.jmx.MethodField;
import org.apache.felix.ipojo.handlers.jmx.NotificationField;
import org.apache.felix.ipojo.handlers.jmx.PropertyField;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MBeanHandler
extends PrimitiveHandler {
    public static final String POST_DEREGISTER_METH_NAME = "postDeregister";
    public static final String PRE_DEREGISTER_METH_NAME = "preDeregister";
    public static final String POST_REGISTER_METH_NAME = "postRegister";
    public static final String PRE_REGISTER_METH_NAME = "preRegister";
    private static final String JMX_CONFIG_ELT = "config";
    private static final String JMX_OBJ_NAME_ELT = "objectName";
    private static final String JMX_OBJ_NAME_DOMAIN_ELT = "domain";
    private static final String JMX_OBJ_NAME_WO_DOMAIN_ELT = "name";
    private static final String JMX_USES_MOSGI_ELT = "usesMOSGi";
    private static final String JMX_METHOD_ELT = "method";
    private static final String JMX_NAME_ELT = "name";
    private static final String JMX_DESCRIPTION_ELT = "description";
    private static final String JMX_PROPERTY_ELT = "property";
    private static final String JMX_FIELD_ELT = "field";
    private static final String JMX_NOTIFICATION_ELT = "notification";
    private static final String JMX_RIGHTS_ELT = "rights";
    private InstanceManager m_instanceManager;
    private ServiceRegistration m_serviceRegistration;
    private JmxConfigFieldMap m_jmxConfigFieldMap;
    private DynamicMBeanImpl m_MBean;
    private String m_namespace = "org.apache.felix.ipojo.handlers.jmx";
    private boolean m_usesMOSGi = false;
    private ObjectName m_objectName;
    private boolean m_registered = false;
    private String m_completeObjNameElt;
    private String m_objNameWODomainElt;
    private String m_domainElt;
    private boolean m_registerCallbacks;
    private MethodMetadata m_preRegisterMeth;
    private MethodMetadata m_postRegisterMeth;
    private MethodMetadata m_preDeregisterMeth;
    private MethodMetadata m_postDeregisterMeth;

    public void configure(Element metadata, Dictionary dict) {
        Element[] attributes;
        PojoMetadata manipulation = this.getPojoMetadata();
        this.m_instanceManager = this.getInstanceManager();
        this.m_jmxConfigFieldMap = new JmxConfigFieldMap();
        Element[] mbeans = metadata.getElements(JMX_CONFIG_ELT, this.m_namespace);
        if (mbeans.length != 1) {
            this.error("A component must have at most one config.");
            this.error("The JMX handler configuration is ignored.");
            return;
        }
        this.m_usesMOSGi = Boolean.parseBoolean(mbeans[0].getAttribute(JMX_USES_MOSGI_ELT));
        this.m_completeObjNameElt = mbeans[0].getAttribute(JMX_OBJ_NAME_ELT);
        this.m_domainElt = mbeans[0].getAttribute(JMX_OBJ_NAME_DOMAIN_ELT);
        this.m_objNameWODomainElt = mbeans[0].getAttribute("name");
        this.m_registerCallbacks = manipulation.isInterfaceImplemented(MBeanRegistration.class.getName());
        if (this.m_registerCallbacks) {
            String[] preRegisterParams = new String[]{MBeanServer.class.getName(), ObjectName.class.getName()};
            this.m_preRegisterMeth = manipulation.getMethod(PRE_REGISTER_METH_NAME, preRegisterParams);
            String[] postRegisterParams = new String[]{Boolean.class.getName()};
            this.m_postRegisterMeth = manipulation.getMethod(POST_REGISTER_METH_NAME, postRegisterParams);
            this.m_preDeregisterMeth = manipulation.getMethod(PRE_DEREGISTER_METH_NAME, new String[0]);
            this.m_postDeregisterMeth = manipulation.getMethod(POST_DEREGISTER_METH_NAME, new String[0]);
        }
        if ((attributes = mbeans[0].getElements(JMX_PROPERTY_ELT)) != null) {
            for (int i = 0; attributes != null && i < attributes.length; ++i) {
                boolean notif = false;
                String field = attributes[i].getAttribute(JMX_FIELD_ELT);
                String name = attributes[i].containsAttribute("name") ? attributes[i].getAttribute("name") : field;
                String rights = attributes[i].containsAttribute(JMX_RIGHTS_ELT) ? attributes[i].getAttribute(JMX_RIGHTS_ELT) : "r";
                PropertyField property = new PropertyField(name, field, rights, MBeanHandler.getTypeFromAttributeField(field, manipulation));
                if (attributes[i].containsAttribute(JMX_NOTIFICATION_ELT)) {
                    notif = Boolean.parseBoolean(attributes[i].getAttribute(JMX_NOTIFICATION_ELT));
                }
                property.setNotifiable(notif);
                if (notif) {
                    NotificationField notification = new NotificationField(name, ((Object)((Object)this)).getClass().getName() + "." + field, null);
                    this.m_jmxConfigFieldMap.addNotificationFromName(name, notification);
                }
                this.m_jmxConfigFieldMap.addPropertyFromName(name, property);
                this.getInstanceManager().register(manipulation.getField(field), (FieldInterceptor)this);
                this.info("property exposed:" + name + " " + field + ":" + MBeanHandler.getTypeFromAttributeField(field, manipulation) + " " + rights + ", Notif=" + notif);
            }
        }
        Element[] methods = mbeans[0].getElements(JMX_METHOD_ELT);
        for (int i = 0; methods != null && i < methods.length; ++i) {
            String name = methods[i].getAttribute("name");
            String description = null;
            if (methods[i].containsAttribute(JMX_DESCRIPTION_ELT)) {
                description = methods[i].getAttribute(JMX_DESCRIPTION_ELT);
            }
            MethodField[] method = this.getMethodsFromName(name, manipulation, description);
            for (int j = 0; j < method.length; ++j) {
                this.m_jmxConfigFieldMap.addMethodFromName(name, method[j]);
                this.info("method exposed:" + method[j].getReturnType() + " " + name);
            }
        }
    }

    public void start() {
        this.m_MBean = this.m_registerCallbacks ? new DynamicMBeanWRegisterImpl(this.m_jmxConfigFieldMap, this.m_instanceManager, this.m_preRegisterMeth, this.m_postRegisterMeth, this.m_preDeregisterMeth, this.m_postDeregisterMeth) : new DynamicMBeanImpl(this.m_jmxConfigFieldMap, this.m_instanceManager);
        if (this.m_usesMOSGi) {
            if (this.m_serviceRegistration != null) {
                this.m_serviceRegistration.unregister();
            }
            BundleContext bundleContext = this.m_instanceManager.getContext();
            Properties properties = new Properties();
            try {
                this.m_objectName = new ObjectName(this.getObjectNameString());
                properties.put("jmxagent.objectName", this.m_objectName.toString());
                this.m_serviceRegistration = bundleContext.registerService(DynamicMBean.class.getName(), (Object)this.m_MBean, (Dictionary)properties);
                this.m_registered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.m_objectName = new ObjectName(this.getObjectNameString());
                ObjectInstance instance = ManagementFactory.getPlatformMBeanServer().registerMBean(this.m_MBean, this.m_objectName);
                if (this.m_registerCallbacks) {
                    this.m_objectName = instance.getObjectName();
                }
                this.m_registered = true;
            }
            catch (Exception e) {
                this.error("Registration of MBean failed.", e);
            }
        }
    }

    private String getObjectNameString() {
        if (this.m_completeObjNameElt != null) {
            return this.m_completeObjNameElt;
        }
        String domain = this.m_domainElt != null ? this.m_domainElt : this.getPackageName(this.m_instanceManager.getClassName());
        String name = "type=" + this.m_instanceManager.getClassName() + ",instance=" + this.m_instanceManager.getInstanceName();
        if (this.m_objNameWODomainElt != null) {
            name = this.m_objNameWODomainElt;
        }
        StringBuffer sb = new StringBuffer();
        if (domain != null && domain.length() > 0) {
            sb.append(domain + ":");
        }
        sb.append(name);
        return sb.toString();
    }

    private String getPackageName(String className) {
        String packageName = "";
        int plotIdx = className.lastIndexOf(".");
        if (plotIdx != -1) {
            packageName = className.substring(0, plotIdx);
        }
        return packageName;
    }

    public void stop() {
        if (this.m_usesMOSGi) {
            if (this.m_serviceRegistration != null) {
                this.m_serviceRegistration.unregister();
            }
        } else if (this.m_objectName != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.m_objectName);
            }
            catch (Exception e) {
                this.error("Unregistration of MBean failed.", e);
            }
            this.m_objectName = null;
        }
        this.m_MBean = null;
        this.m_registered = false;
    }

    public void onSet(Object pojo, String fieldName, Object value) {
        PropertyField propertyField = this.m_jmxConfigFieldMap.getPropertyFromField(fieldName);
        if (propertyField != null) {
            if (propertyField.isNotifiable()) {
                this.m_MBean.sendNotification(propertyField.getName() + " changed", propertyField.getName(), propertyField.getType(), propertyField.getValue(), value);
            }
            propertyField.setValue(value);
        }
    }

    public Object onGet(Object pojo, String fieldName, Object value) {
        PropertyField propertyField = this.m_jmxConfigFieldMap.getPropertyFromField(fieldName);
        if (propertyField != null) {
            this.m_instanceManager.onSet(pojo, fieldName, propertyField.getValue());
            return propertyField.getValue();
        }
        return value;
    }

    private static String getTypeFromAttributeField(String fieldRequire, PojoMetadata manipulation) {
        FieldMetadata field = manipulation.getField(fieldRequire);
        if (field == null) {
            return null;
        }
        return FieldMetadata.getReflectionType((String)field.getFieldType());
    }

    private MethodField[] getMethodsFromName(String methodName, PojoMetadata manipulation, String description) {
        MethodMetadata[] fields = manipulation.getMethods(methodName);
        if (fields.length == 0) {
            return null;
        }
        MethodField[] ret = new MethodField[fields.length];
        if (fields.length == 1) {
            ret[0] = new MethodField(fields[0], description);
            return ret;
        }
        for (int i = 0; i < fields.length; ++i) {
            ret[i] = new MethodField(fields[i], description);
        }
        return ret;
    }

    public HandlerDescription getDescription() {
        return new JMXHandlerDescription(this);
    }

    public String getUsedObjectName() {
        if (this.m_objectName != null) {
            return this.m_objectName.toString();
        }
        return "";
    }

    public boolean isRegistered() {
        return this.m_registered;
    }

    public boolean isUsesMOSGi() {
        return this.m_usesMOSGi;
    }

    public boolean isMOSGiExists() {
        for (Bundle bundle : this.m_instanceManager.getContext().getBundles()) {
            String symbolicName = bundle.getSymbolicName();
            if (!"org.apache.felix.mosgi.jmx.agent".equals(symbolicName)) continue;
            return true;
        }
        return false;
    }
}

