/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.jmx;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.jmx.JmxConfigFieldMap;
import org.apache.felix.ipojo.handlers.jmx.MethodField;
import org.apache.felix.ipojo.handlers.jmx.NotificationField;
import org.apache.felix.ipojo.handlers.jmx.PropertyField;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.util.Callback;

public class DynamicMBeanImpl
extends NotificationBroadcasterSupport
implements DynamicMBean {
    protected final InstanceManager m_instanceManager;
    private JmxConfigFieldMap m_configMap;
    private MBeanInfo m_mBeanInfo;
    private String m_className = this.getClass().getName();
    private int m_sequenceNumber = 0;

    public DynamicMBeanImpl(JmxConfigFieldMap properties, InstanceManager instanceManager) {
        this.m_configMap = properties;
        this.m_instanceManager = instanceManager;
        this.buildMBeanInfo();
    }

    public Object getAttribute(String arg0) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PropertyField attribute = this.m_configMap.getPropertyFromName(arg0);
        if (attribute == null) {
            throw new AttributeNotFoundException(arg0 + " not found");
        }
        return attribute.getValue();
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new IllegalArgumentException("attributeNames[] cannot be null");
        }
        AttributeList resultList = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            PropertyField propertyField = this.m_configMap.getPropertyFromField(attributeNames[i]);
            if (propertyField == null) continue;
            resultList.add(new Attribute(attributeNames[i], propertyField.getValue()));
        }
        return resultList;
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_mBeanInfo;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        block5: {
            MethodField method = this.m_configMap.getMethodFromName(operationName, signature);
            if (method != null) {
                MethodMetadata methodCall = method.getMethod();
                Callback mc = new Callback(methodCall, this.m_instanceManager);
                try {
                    return mc.call(params);
                }
                catch (NoSuchMethodException e) {
                    System.err.println("No such method!: " + operationName);
                    e.printStackTrace();
                    break block5;
                }
                catch (IllegalAccessException e) {
                    System.err.println("Illegal Access Exception");
                    e.printStackTrace();
                    break block5;
                }
                catch (InvocationTargetException e) {
                    System.err.println("Invocation Target Exception");
                    e.printStackTrace();
                    break block5;
                }
            }
            throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.m_className);
        }
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.m_className + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.m_className + " with null attribute name");
        }
        PropertyField propertyField = this.m_configMap.getPropertyFromName(name);
        if (propertyField == null) {
            throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.m_className);
        }
        if (!propertyField.isWritable()) {
            throw new InvalidAttributeValueException("Attribute " + name + " can not be set");
        }
        if (value == null) {
            try {
                this.m_instanceManager.onSet(null, propertyField.getField(), null);
            }
            catch (Exception e) {
                throw new InvalidAttributeValueException("Cannot set attribute " + name + " to null");
            }
        } else {
            this.m_instanceManager.onSet(null, propertyField.getField(), value);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.m_className);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    private void buildMBeanInfo() {
        String dDescription = this.m_configMap.getDecription();
        MBeanAttributeInfo[] dAttributes = null;
        if (this.m_configMap == null) {
            return;
        }
        if (this.m_configMap.getProperties() != null) {
            ArrayList<MBeanAttributeInfo> lAttributes = null;
            lAttributes = new ArrayList<MBeanAttributeInfo>();
            for (PropertyField propertyField : this.m_configMap.getProperties()) {
                lAttributes.add(new MBeanAttributeInfo(propertyField.getName(), propertyField.getType(), propertyField.getDescription(), propertyField.isReadable(), propertyField.isWritable(), false));
            }
            dAttributes = lAttributes.toArray(new MBeanAttributeInfo[lAttributes.size()]);
        }
        MBeanOperationInfo[] dOperations = null;
        if (this.m_configMap.getMethods() != null) {
            ArrayList<MBeanOperationInfo> lOperations = new ArrayList<MBeanOperationInfo>();
            for (MethodField[] method : this.m_configMap.getMethods()) {
                for (int i = 0; i < method.length; ++i) {
                    lOperations.add(new MBeanOperationInfo(method[i].getName(), method[i].getDescription(), method[i].getParams(), method[i].getReturnType(), 3));
                }
                dOperations = lOperations.toArray(new MBeanOperationInfo[lOperations.size()]);
            }
        }
        MBeanNotificationInfo[] dNotification = new MBeanNotificationInfo[]{};
        if (this.m_configMap.getMethods() != null) {
            ArrayList<MBeanNotificationInfo> lNotifications = new ArrayList<MBeanNotificationInfo>();
            for (NotificationField notification : this.m_configMap.getNotifications()) {
                lNotifications.add(notification.getNotificationInfo());
            }
            dNotification = lNotifications.toArray(new MBeanNotificationInfo[lNotifications.size()]);
        }
        this.m_mBeanInfo = new MBeanInfo(this.m_className, dDescription, dAttributes, null, dOperations, dNotification);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] dNotification = new MBeanNotificationInfo[]{};
        if (this.m_configMap.getMethods() != null) {
            ArrayList<MBeanNotificationInfo> lNotifications = new ArrayList<MBeanNotificationInfo>();
            for (NotificationField notification : this.m_configMap.getNotifications()) {
                lNotifications.add(notification.getNotificationInfo());
            }
            dNotification = lNotifications.toArray(new MBeanNotificationInfo[lNotifications.size()]);
        }
        return dNotification;
    }

    public void sendNotification(String msg, String attributeName, String attributeType, Object oldValue, Object newValue) {
        long timeStamp = System.currentTimeMillis();
        if (newValue.equals(oldValue)) {
            return;
        }
        ++this.m_sequenceNumber;
        AttributeChangeNotification notification = new AttributeChangeNotification(this, this.m_sequenceNumber, timeStamp, msg, attributeName, attributeType, oldValue, newValue);
        this.sendNotification(notification);
        this.m_instanceManager.getFactory().getLogger().log(3, "Notification sent");
    }
}

