/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.servlet.ServletException;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistrationHandler;
import org.apache.felix.httplite.osgi.ServiceRegistrationResolver;
import org.apache.felix.httplite.servlet.ConcreteServletInputStream;
import org.apache.felix.httplite.servlet.HttpServletRequestImpl;
import org.apache.felix.httplite.servlet.HttpServletResponseImpl;

public class Connection {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_REQUESTLIMIT = 50;
    private final Socket m_socket;
    private ConcreteServletInputStream m_is;
    private OutputStream m_os;
    private int m_requestCount = 0;
    private final int m_requestLimit;
    private final ServiceRegistrationResolver m_resolver;
    private final Logger m_logger;

    public Connection(Socket socket, ServiceRegistrationResolver resolver, Logger logger) throws IOException {
        this(socket, 10000, 50, resolver, logger);
    }

    public Connection(Socket socket, int timeout, int requestLimit, ServiceRegistrationResolver resolver, Logger logger) throws IOException {
        this.m_socket = socket;
        this.m_resolver = resolver;
        this.m_logger = logger;
        this.m_socket.setSoTimeout(timeout);
        this.m_socket.setTcpNoDelay(true);
        this.m_requestLimit = requestLimit;
        try {
            this.m_is = new ConcreteServletInputStream(new BufferedInputStream(this.m_socket.getInputStream()));
            this.m_os = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException ex) {
            try {
                this.m_socket.close();
            }
            catch (IOException ex2) {
                this.m_logger.log(1, "Error closing socket.", ex);
            }
            if (this.m_is != null) {
                try {
                    this.m_is.close();
                }
                catch (IOException ex2) {
                    this.m_logger.log(1, "Error closing socket input stream.", ex2);
                }
            }
            if (this.m_os != null) {
                try {
                    this.m_os.close();
                }
                catch (IOException ex2) {
                    this.m_logger.log(1, "Error closing socket output stream.", ex2);
                }
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException, ServletException {
        HttpServletRequestImpl request = this.m_resolver.getServletRequest(this.m_socket);
        HttpServletResponseImpl response = this.m_resolver.getServletResponse(this.m_os);
        try {
            boolean close = false;
            while (!close) {
                try {
                    request.parseRequestLine(this.m_is);
                }
                catch (IOException e) {
                    this.m_logger.log(1, "Error with request: " + request.toString() + ": " + e.getMessage());
                    throw e;
                }
                ++this.m_requestCount;
                boolean error = false;
                this.m_logger.log(4, "Processing " + request.getRequestURI() + " (" + (this.m_requestLimit - this.m_requestCount) + " remaining)");
                if (request.getProtocol().equals("HTTP/1.1")) {
                    response.sendContinueResponse();
                }
                request.parseHeader(this.m_is);
                String v = request.getHeader("Connection");
                if (request.getProtocol().equals("HTTP/1.0") && (v == null || !v.equalsIgnoreCase("keep-alive")) || v != null && v.equalsIgnoreCase("close")) {
                    close = true;
                    response.setConnectionType("close");
                } else if (this.m_requestCount >= this.m_requestLimit) {
                    close = true;
                    response.setConnectionType("close");
                }
                if (!HttpServletRequestImpl.isSupportedMethod(request.getMethod())) {
                    error = true;
                    response.setConnectionType("close");
                    response.sendNotImplementedResponse();
                }
                if (!error && request.getProtocol().equals("HTTP/1.1") && request.getHeader("Host") == null) {
                    error = true;
                    response.setConnectionType("close");
                    response.sendMissingHostResponse();
                }
                request.parseBody(this.m_is);
                if (error) continue;
                ServiceRegistrationHandler processor = this.m_resolver.getProcessor(request, response, request.getRequestURI());
                if (processor != null) {
                    processor.handle(close);
                    this.m_logger.log(4, "Processed " + request.toString());
                    close = true;
                    continue;
                }
                close = true;
                response.setConnectionType("close");
                response.sendNotFoundResponse();
            }
        }
        finally {
            try {
                this.m_is.close();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Error closing socket input stream.", ex);
            }
            try {
                this.m_os.close();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Error closing socket output stream.", ex);
            }
            try {
                this.m_socket.close();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Error closing socket.", ex);
            }
        }
    }
}

