/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.DispatcherType;
import org.apache.felix.http.base.internal.HttpConfig;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.registry.ServletResolution;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public final class HandlerRegistry {
    private static FilterHandler[] EMPTY_FILTER_HANDLER = new FilterHandler[0];
    private volatile List<PerContextHandlerRegistry> registrations = Collections.emptyList();
    private final HttpConfig config;

    public HandlerRegistry(HttpConfig config) {
        this.config = config;
    }

    public HttpConfig getConfig() {
        return this.config;
    }

    public void init() {
        this.add(new PerContextHandlerRegistry(this.config));
    }

    public void reset() {
        this.registrations.clear();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<PerContextHandlerRegistry> list;
        HandlerRegistry handlerRegistry = this;
        synchronized (handlerRegistry) {
            list = new ArrayList<PerContextHandlerRegistry>(this.registrations);
            this.registrations = Collections.emptyList();
        }
        for (PerContextHandlerRegistry r : list) {
            r.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull ServletContextHelperInfo info) {
        HandlerRegistry handlerRegistry = this;
        synchronized (handlerRegistry) {
            ArrayList<PerContextHandlerRegistry> updatedList = new ArrayList<PerContextHandlerRegistry>(this.registrations);
            Iterator i = updatedList.iterator();
            while (i.hasNext()) {
                PerContextHandlerRegistry reg = (PerContextHandlerRegistry)i.next();
                if (reg.getContextServiceId() != info.getServiceId()) continue;
                i.remove();
                this.registrations = updatedList;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull PerContextHandlerRegistry registry) {
        HandlerRegistry handlerRegistry = this;
        synchronized (handlerRegistry) {
            ArrayList<PerContextHandlerRegistry> updatedList = new ArrayList<PerContextHandlerRegistry>(this.registrations);
            updatedList.add(registry);
            Collections.sort(updatedList);
            this.registrations = updatedList;
        }
    }

    public PerContextHandlerRegistry getRegistry(long key) {
        List<PerContextHandlerRegistry> list = this.registrations;
        for (PerContextHandlerRegistry r : list) {
            if (key != r.getContextServiceId()) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public ServletResolution getErrorHandler(@NotNull String requestURI, Long serviceId, int code, Throwable exception) {
        ServletHandler handler;
        PerContextHandlerRegistry reg;
        if (serviceId == null) {
            PerContextHandlerRegistry found = null;
            List<PerContextHandlerRegistry> regs = this.registrations;
            for (PerContextHandlerRegistry r : regs) {
                String path = r.isMatching(requestURI);
                if (path == null) continue;
                found = r;
                break;
            }
            reg = found;
        } else {
            reg = this.getRegistry(serviceId);
        }
        if (reg != null && (handler = reg.getErrorHandler(code, exception)) != null) {
            ServletResolution res = new ServletResolution();
            res.handler = handler;
            res.handlerRegistry = reg;
            return res;
        }
        return null;
    }

    public FilterHandler[] getFilters(@NotNull ServletResolution pr, @NotNull DispatcherType dispatcherType, @NotNull String requestURI) {
        if (pr != null && pr.handlerRegistry != null) {
            return pr.handlerRegistry.getFilterHandlers(pr.handler, dispatcherType, requestURI);
        }
        return EMPTY_FILTER_HANDLER;
    }

    public PathResolution resolveServlet(@NotNull String requestURI) {
        List<PerContextHandlerRegistry> regs = this.registrations;
        for (PerContextHandlerRegistry r : regs) {
            PathResolution ps;
            String path = r.isMatching(requestURI);
            if (path == null || (ps = r.resolve(path)) == null) continue;
            ps.requestURI = path;
            ps.handlerRegistry = r;
            return ps;
        }
        return null;
    }

    public ServletResolution resolveServletByName(long contextId, @NotNull String name) {
        ServletHandler handler;
        PerContextHandlerRegistry reg = this.getRegistry(contextId);
        if (reg != null && (handler = reg.resolveServletByName(name)) != null) {
            ServletResolution resolution = new ServletResolution();
            resolution.handler = handler;
            resolution.handlerRegistry = reg;
            return resolution;
        }
        return null;
    }

    public boolean getRuntimeInfo(@NotNull ServletContextDTO dto, @NotNull FailedDTOHolder failedDTOHolder) {
        PerContextHandlerRegistry reg = this.getRegistry(dto.serviceId);
        if (reg != null) {
            reg.getRuntime(dto, failedDTOHolder);
            return true;
        }
        return false;
    }

    public PerContextHandlerRegistry getBestMatchingRegistry(String requestURI) {
        PerContextHandlerRegistry found = null;
        List<PerContextHandlerRegistry> regs = this.registrations;
        for (PerContextHandlerRegistry r : regs) {
            String path = r.isMatching(requestURI);
            if (path == null) continue;
            found = r;
            break;
        }
        return found;
    }
}

