/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.osgi.framework.BundleContext;

public final class JettyConfig {
    public static final String FELIX_HOST = "org.apache.felix.http.host";
    public static final String HTTP_PORT = "org.osgi.service.http.port";
    public static final String HTTPS_PORT = "org.osgi.service.http.port.secure";
    public static final String HTTP_TIMEOUT = "org.apache.felix.http.timeout";
    public static final String FELIX_KEYSTORE = "org.apache.felix.https.keystore";
    private static final String OSCAR_KEYSTORE = "org.ungoverned.osgi.bundle.https.keystore";
    public static final String FELIX_KEYSTORE_PASSWORD = "org.apache.felix.https.keystore.password";
    private static final String OSCAR_KEYSTORE_PASSWORD = "org.ungoverned.osgi.bundle.https.password";
    public static final String FELIX_KEYSTORE_KEY_PASSWORD = "org.apache.felix.https.keystore.key.password";
    private static final String OSCAR_KEYSTORE_KEY_PASSWORD = "org.ungoverned.osgi.bundle.https.key.password";
    public static final String FELIX_KEYSTORE_TYPE = "org.apache.felix.https.keystore.type";
    public static final String FELIX_HTTPS_ENABLE = "org.apache.felix.https.enable";
    private static final String OSCAR_HTTPS_ENABLE = "org.ungoverned.osgi.bundle.https.enable";
    public static final String FELIX_HTTP_ENABLE = "org.apache.felix.http.enable";
    public static final String FELIX_TRUSTSTORE = "org.apache.felix.https.truststore";
    public static final String FELIX_TRUSTSTORE_PASSWORD = "org.apache.felix.https.truststore.password";
    public static final String FELIX_TRUSTSTORE_TYPE = "org.apache.felix.https.truststore.type";
    public static final String FELIX_HTTPS_CLIENT_CERT = "org.apache.felix.https.clientcertificate";
    public static final String FELIX_SESSION_TIMEOUT = "org.apache.felix.http.session.timeout";
    public static final String FELIX_JETTY_THREADPOOL_MAX = "org.apache.felix.http.jetty.threadpool.max";
    public static final String FELIX_JETTY_ACCEPTORS = "org.apache.felix.http.jetty.acceptors";
    public static final String FELIX_JETTY_SELECTORS = "org.apache.felix.http.jetty.selectors";
    public static final String FELIX_JETTY_HEADER_BUFFER_SIZE = "org.apache.felix.http.jetty.headerBufferSize";
    public static final String FELIX_JETTY_REQUEST_BUFFER_SIZE = "org.apache.felix.http.jetty.requestBufferSize";
    public static final String FELIX_JETTY_RESPONSE_BUFFER_SIZE = "org.apache.felix.http.jetty.responseBufferSize";
    public static final String FELIX_JETTY_MAX_FORM_SIZE = "org.apache.felix.http.jetty.maxFormSize";
    public static final String FELIX_HTTP_MBEANS = "org.apache.felix.http.mbeans";
    public static final String FELIX_HTTP_CONTEXT_PATH = "org.apache.felix.http.context_path";
    public static final String FELIX_HTTP_PATH_EXCLUSIONS = "org.apache.felix.http.path_exclusions";
    @Deprecated
    public static final String FELIX_JETTY_EXCLUDED_SUITES_OLD = "org.apache.felix.https.jetty.cipersuites.excluded";
    public static final String FELIX_JETTY_EXCLUDED_SUITES = "org.apache.felix.https.jetty.ciphersuites.excluded";
    @Deprecated
    public static final String FELIX_JETTY_INCLUDED_SUITES_OLD = "org.apache.felix.https.jetty.cipersuites.included";
    public static final String FELIX_JETTY_INCLUDED_SUITES = "org.apache.felix.https.jetty.ciphersuites.included";
    public static final String FELIX_JETTY_SEND_SERVER_HEADER = "org.apache.felix.http.jetty.sendServerHeader";
    public static final String FELIX_JETTY_INCLUDED_PROTOCOLS = "org.apache.felix.https.jetty.protocols.included";
    public static final String FELIX_JETTY_EXCLUDED_PROTOCOLS = "org.apache.felix.https.jetty.protocols.excluded";
    public static final String FELIX_JETTY_RENEGOTIATION_ALLOWED = "org.apache.felix.https.jetty.renegotiateAllowed";
    public static final String FELIX_PROXY_LOAD_BALANCER_CONNECTION_ENABLE = "org.apache.felix.proxy.load.balancer.connection.enable";
    public static final String FELIX_JETTY_SESSION_COOKIE_HTTP_ONLY = "org.apache.felix.https.jetty.session.cookie.httpOnly";
    public static final String FELIX_JETTY_SESSION_COOKIE_SECURE = "org.apache.felix.https.jetty.session.cookie.secure";
    public static final String FELIX_JETTY_SERVLET_SESSION_ID_PATH_PARAMETER_NAME = "org.eclipse.jetty.servlet.SessionIdPathParameterName";
    public static final String FELIX_JETTY_SERVLET_CHECK_REMOTE_SESSION_ENCODING = "org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding";
    public static final String FELIX_JETTY_SERVLET_SESSION_COOKIE_NAME = "org.eclipse.jetty.servlet.SessionCookie";
    public static final String FELIX_JETTY_SERVLET_SESSION_DOMAIN = "org.eclipse.jetty.servlet.SessionDomain";
    public static final String FELIX_JETTY_SERVLET_SESSION_PATH = "org.eclipse.jetty.servlet.SessionPath";
    public static final String FELIX_JETTY_SERVLET_SESSION_MAX_AGE = "org.eclipse.jetty.servlet.MaxAge";
    public static final String FELIX_JETTY_SESSION_SCAVENGING_INTERVAL = "org.eclipse.jetty.servlet.SessionScavengingInterval";
    public static final String FELIX_HTTP_SERVICE_NAME = "org.apache.felix.http.name";
    public static final String FELIX_HTTP_REQUEST_LOG_FILTER = "org.apache.felix.http.requestlog.filter";
    public static final String FELIX_HTTP_REQUEST_LOG_OSGI_ENABLE = "org.apache.felix.http.requestlog.osgi.enable";
    public static final String FELIX_HTTP_REQUEST_LOG_OSGI_SERVICE_NAME = "org.apache.felix.http.requestlog.osgi.name";
    public static final String FELIX_HTTP_REQUEST_LOG_OSGI_LEVEL = "org.apache.felix.http.requestlog.osgi.level";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_PATH = "org.apache.felix.http.requestlog.file.path";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_SERVICE_NAME = "org.apache.felix.http.requestlog.file.name";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_ASYNC = "org.apache.felix.http.requestlog.file.async";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_APPEND = "org.apache.felix.http.requestlog.file.append";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_RETAIN_DAYS = "org.apache.felix.http.requestlog.file.retaindays";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_FILENAME_DATE_FORMAT = "org.apache.felix.http.requestlog.file.dateformat";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_EXTENDED = "org.apache.felix.http.requestlog.file.extended";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_IGNORE_PATHS = "org.apache.felix.http.requestlog.file.ignorepaths";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_LOG_COOKIES = "org.apache.felix.http.requestlog.file.logcookies";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_LOG_SERVER = "org.apache.felix.http.requestlog.file.logserver";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_LOG_LATENCY = "org.apache.felix.http.requestlog.file.loglatency";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_DATE_FORMAT = "org.apache.felix.http.requestlog.file.logdateformat";
    public static final String FELIX_HTTP_REQUEST_LOG_FILE_TIMEZONE = "org.apache.felix.http.requestlog.file.timezone";
    public static final String FELIX_CUSTOM_HTTP_RUNTIME_PROPERTY_PREFIX = "org.apache.felix.http.runtime.init.";
    public static final String FELIX_JETTY_GZIP_HANDLER_ENABLE = "org.apache.felix.jetty.gziphandler.enable";
    public static final String FELIX_JETTY_GZIP_MIN_GZIP_SIZE = "org.apache.felix.jetty.gzip.minGzipSize";
    public static final String FELIX_JETTY_GZIP_COMPRESSION_LEVEL = "org.apache.felix.jetty.gzip.compressionLevel";
    public static final String FELIX_JETTY_GZIP_INFLATE_BUFFER_SIZE = "org.apache.felix.jetty.gzip.inflateBufferSize";
    public static final String FELIX_JETTY_GZIP_SYNC_FLUSH = "org.apache.felix.jetty.gzip.syncFlush";
    public static final String FELIX_JETTY_GZIP_EXCLUDED_USER_AGENT = "org.apache.felix.jetty.gzip.excludedUserAgents";
    public static final String FELIX_JETTY_GZIP_INCLUDED_METHODS = "org.apache.felix.jetty.gzip.includedMethods";
    public static final String FELIX_JETTY_GZIP_EXCLUDED_METHODS = "org.apache.felix.jetty.gzip.excludedMethods";
    public static final String FELIX_JETTY_GZIP_INCLUDED_PATHS = "org.apache.felix.jetty.gzip.includedPaths";
    public static final String FELIX_JETTY_GZIP_EXCLUDED_PATHS = "org.apache.felix.jetty.gzip.excludedPaths";
    public static final String FELIX_JETTY_GZIP_INCLUDED_MIME_TYPES = "org.apache.felix.jetty.gzip.includedMimeTypes";
    public static final String FELIX_JETTY_GZIP_EXCLUDED_MIME_TYPES = "org.apache.felix.jetty.gzip.excludedMimeTypes";
    private final BundleContext context;
    private volatile Dictionary<String, ?> config;

    private static String validateContextPath(String ctxPath) {
        if (ctxPath == null || ctxPath.length() == 0 || "/".equals(ctxPath)) {
            return "/";
        }
        if (!ctxPath.startsWith("/")) {
            ctxPath = "/".concat(ctxPath);
        }
        while (ctxPath.endsWith("/")) {
            ctxPath = ctxPath.substring(0, ctxPath.length() - 1);
        }
        return ctxPath;
    }

    public JettyConfig(BundleContext context) {
        this.context = context;
        this.reset();
    }

    public boolean getBooleanProperty(String name, boolean defValue) {
        String value = this.getProperty(name, null);
        if (value != null) {
            return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        return defValue;
    }

    public String getClientcert() {
        return this.getProperty(FELIX_HTTPS_CLIENT_CERT, "none");
    }

    public String getContextPath() {
        return JettyConfig.validateContextPath(this.getProperty(FELIX_HTTP_CONTEXT_PATH, null));
    }

    public String[] getExcludedCipherSuites() {
        return this.getStringArrayProperty(FELIX_JETTY_EXCLUDED_SUITES, this.getStringArrayProperty(FELIX_JETTY_EXCLUDED_SUITES_OLD, null));
    }

    public String[] getIncludedProtocols() {
        return this.getStringArrayProperty(FELIX_JETTY_INCLUDED_PROTOCOLS, null);
    }

    public String[] getExcludedProtocols() {
        return this.getStringArrayProperty(FELIX_JETTY_EXCLUDED_PROTOCOLS, null);
    }

    public int getHeaderSize() {
        return this.getIntProperty(FELIX_JETTY_HEADER_BUFFER_SIZE, 16384);
    }

    public String getHost() {
        return this.getProperty(FELIX_HOST, null);
    }

    public int getHttpPort() {
        return this.determinePort(String.valueOf(this.getProperty(HTTP_PORT)), 8080);
    }

    public int getHttpsPort() {
        return this.determinePort(String.valueOf(this.getProperty(HTTPS_PORT)), 8443);
    }

    public int getHttpTimeout() {
        return this.getIntProperty(HTTP_TIMEOUT, 60000);
    }

    public String[] getIncludedCipherSuites() {
        return this.getStringArrayProperty(FELIX_JETTY_INCLUDED_SUITES, this.getStringArrayProperty(FELIX_JETTY_INCLUDED_SUITES_OLD, null));
    }

    public int getIntProperty(String name, int defValue) {
        return this.parseInt(this.getProperty(name, null), defValue);
    }

    public long getLongProperty(String name, long defValue) {
        return this.parseLong(this.getProperty(name, null), defValue);
    }

    public String getKeyPassword() {
        return this.getProperty(FELIX_KEYSTORE_KEY_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_KEY_PASSWORD));
    }

    public String getKeystore() {
        return this.getProperty(FELIX_KEYSTORE, this.context.getProperty(OSCAR_KEYSTORE));
    }

    public String getKeystoreType() {
        return this.getProperty(FELIX_KEYSTORE_TYPE, KeyStore.getDefaultType());
    }

    public String getPassword() {
        return this.getProperty(FELIX_KEYSTORE_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_PASSWORD));
    }

    public String[] getPathExclusions() {
        return this.getStringArrayProperty(FELIX_HTTP_PATH_EXCLUSIONS, new String[]{"/system"});
    }

    public String getProperty(String name, String defValue) {
        Object value = this.getProperty(name);
        return value != null ? String.valueOf(value) : defValue;
    }

    public int getThreadPoolMax() {
        return this.getIntProperty(FELIX_JETTY_THREADPOOL_MAX, -1);
    }

    public int getAcceptors() {
        return this.getIntProperty(FELIX_JETTY_ACCEPTORS, -1);
    }

    public int getSelectors() {
        return this.getIntProperty(FELIX_JETTY_SELECTORS, -1);
    }

    public int getRequestBufferSize() {
        return this.getIntProperty(FELIX_JETTY_REQUEST_BUFFER_SIZE, 8192);
    }

    public int getResponseBufferSize() {
        return this.getIntProperty(FELIX_JETTY_RESPONSE_BUFFER_SIZE, 24576);
    }

    public int getMaxFormSize() {
        return this.getIntProperty(FELIX_JETTY_MAX_FORM_SIZE, 204800);
    }

    public int getSessionTimeout() {
        return this.getIntProperty(FELIX_SESSION_TIMEOUT, 0);
    }

    public String getTrustPassword() {
        return this.getProperty(FELIX_TRUSTSTORE_PASSWORD, null);
    }

    public String getTruststore() {
        String value = this.getProperty(FELIX_TRUSTSTORE, null);
        return value == null || value.trim().length() == 0 ? null : value;
    }

    public String getTruststoreType() {
        return this.getProperty(FELIX_TRUSTSTORE_TYPE, KeyStore.getDefaultType());
    }

    public boolean isRegisterMBeans() {
        return this.getBooleanProperty(FELIX_HTTP_MBEANS, false);
    }

    public boolean isUseHttp() {
        boolean useHttp = this.getBooleanProperty(FELIX_HTTP_ENABLE, true);
        return useHttp && this.getHttpPort() > 0;
    }

    public boolean isSendServerHeader() {
        return this.getBooleanProperty(FELIX_JETTY_SEND_SERVER_HEADER, false);
    }

    public boolean isUseHttps() {
        boolean useHttps = this.getBooleanProperty(FELIX_HTTPS_ENABLE, this.getBooleanProperty(OSCAR_HTTPS_ENABLE, false));
        return useHttps && this.getHttpsPort() > 0;
    }

    public boolean isProxyLoadBalancerConnection() {
        return this.getBooleanProperty(FELIX_PROXY_LOAD_BALANCER_CONNECTION_ENABLE, false);
    }

    public boolean isRenegotiationAllowed() {
        return this.getBooleanProperty(FELIX_JETTY_RENEGOTIATION_ALLOWED, false);
    }

    public String getHttpServiceName() {
        return (String)this.getProperty(FELIX_HTTP_SERVICE_NAME);
    }

    public String getRequestLogFilter() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILTER, null);
    }

    public boolean isRequestLogOSGiEnabled() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_OSGI_ENABLE, false);
    }

    public String getRequestLogOSGiServiceName() {
        return (String)this.getProperty(FELIX_HTTP_REQUEST_LOG_OSGI_SERVICE_NAME);
    }

    public int getRequestLogOSGiLevel() {
        return this.getIntProperty(FELIX_HTTP_REQUEST_LOG_OSGI_LEVEL, 3);
    }

    public String getRequestLogFilePath() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILE_PATH, null);
    }

    public String getRequestLogFileServiceName() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILE_SERVICE_NAME, "file");
    }

    public boolean isRequestLogFileAsync() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_ASYNC, false);
    }

    public boolean isRequestLogFileAppend() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_APPEND, true);
    }

    public int getRequestLogFileRetainDays() {
        return this.getIntProperty(FELIX_HTTP_REQUEST_LOG_FILE_RETAIN_DAYS, 31);
    }

    public String getRequestLogFilenameDateFormat() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILE_FILENAME_DATE_FORMAT, null);
    }

    public boolean isRequestLogFileExtended() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_EXTENDED, false);
    }

    public String[] getRequestLogFileIgnorePaths() {
        return this.getStringArrayProperty(FELIX_HTTP_REQUEST_LOG_FILE_IGNORE_PATHS, new String[0]);
    }

    public boolean isRequestLogFileLogCookies() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_LOG_COOKIES, false);
    }

    public boolean isRequestLogFileLogServer() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_LOG_SERVER, false);
    }

    public boolean isRequestLogFileLogLatency() {
        return this.getBooleanProperty(FELIX_HTTP_REQUEST_LOG_FILE_LOG_LATENCY, false);
    }

    public String getRequestLogDateFormat() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILE_DATE_FORMAT, null);
    }

    public String getRequestLogTimeZone() {
        return this.getProperty(FELIX_HTTP_REQUEST_LOG_FILE_TIMEZONE, null);
    }

    public boolean isGzipHandlerEnabled() {
        return this.getBooleanProperty(FELIX_JETTY_GZIP_HANDLER_ENABLE, false);
    }

    public int getGzipMinGzipSize() {
        return this.getIntProperty(FELIX_JETTY_GZIP_MIN_GZIP_SIZE, 16);
    }

    public int getGzipCompressionLevel() {
        return this.getIntProperty(FELIX_JETTY_GZIP_COMPRESSION_LEVEL, -1);
    }

    public int getGzipInflateBufferSize() {
        return this.getIntProperty(FELIX_JETTY_GZIP_INFLATE_BUFFER_SIZE, -1);
    }

    public boolean isGzipSyncFlush() {
        return this.getBooleanProperty(FELIX_JETTY_GZIP_SYNC_FLUSH, false);
    }

    public String[] getGzipExcludedUserAgent() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_EXCLUDED_USER_AGENT, new String[0]);
    }

    public String[] getGzipIncludedMethods() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_INCLUDED_METHODS, new String[0]);
    }

    public String[] getGzipExcludedMethods() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_EXCLUDED_METHODS, new String[0]);
    }

    public String[] getGzipIncludedPaths() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_INCLUDED_PATHS, new String[0]);
    }

    public String[] getGzipExcludedPaths() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_EXCLUDED_PATHS, new String[0]);
    }

    public String[] getGzipIncludedMimeTypes() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_INCLUDED_MIME_TYPES, new String[0]);
    }

    public String[] getGzipExcludedMimeTypes() {
        return this.getStringArrayProperty(FELIX_JETTY_GZIP_EXCLUDED_MIME_TYPES, new String[0]);
    }

    public void reset() {
        this.update(null);
    }

    public void setServiceProperties(Hashtable<String, Object> props) {
        props.put(HTTP_PORT, Integer.toString(this.getHttpPort()));
        props.put(HTTPS_PORT, Integer.toString(this.getHttpsPort()));
        props.put(FELIX_HTTP_ENABLE, Boolean.toString(this.isUseHttp()));
        props.put(FELIX_HTTPS_ENABLE, Boolean.toString(this.isUseHttps()));
        if (this.getHttpServiceName() != null) {
            props.put(FELIX_HTTP_SERVICE_NAME, this.getHttpServiceName());
        }
        props.put("org.apache.felix.http.session.invalidate", this.getBooleanProperty("org.apache.felix.http.session.invalidate", true));
        props.put("org.apache.felix.http.session.uniqueid", this.getBooleanProperty("org.apache.felix.http.session.uniqueid", true));
        this.addCustomServiceProperties(props);
    }

    private void addCustomServiceProperties(Hashtable<String, Object> props) {
        Enumeration<String> keys = this.config.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(FELIX_CUSTOM_HTTP_RUNTIME_PROPERTY_PREFIX)) continue;
            props.put(key.substring(FELIX_CUSTOM_HTTP_RUNTIME_PROPERTY_PREFIX.length()), this.config.get(key));
        }
    }

    public boolean update(Dictionary<String, ?> props) {
        Dictionary<String, ?> currentConfig;
        if (props == null) {
            props = new Hashtable();
        }
        if ((currentConfig = this.config) == null || !props.equals(currentConfig)) {
            this.config = props;
            return true;
        }
        return false;
    }

    private void closeSilently(ServerSocket resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int determinePort(String portProp, int dflt) {
        if (portProp == null || "".equals(portProp.trim())) {
            return dflt;
        }
        if ("*".equals(portProp = portProp.trim()) || "0".equals(portProp)) {
            return this.getSocketPort(0);
        }
        char startsWith = portProp.charAt(0);
        char endsWith = portProp.charAt(portProp.length() - 1);
        int minPort = 1;
        int maxPort = 65535;
        if (!(!portProp.contains(",") || startsWith != '[' && startsWith != '(' || endsWith != ']' && endsWith != ')')) {
            int end;
            String interval = portProp.substring(1, portProp.length() - 1);
            int comma = interval.indexOf(44);
            int start = comma == 0 ? minPort : this.parseInt(interval.substring(0, comma), minPort);
            int n = end = comma == interval.length() - 1 ? maxPort : this.parseInt(interval.substring(comma + 1), maxPort);
            if (startsWith == '(') {
                ++start;
            }
            if (endsWith == ')') {
                --end;
            }
            int port = start - 1;
            for (int i = start; port < start && i <= end; ++i) {
                port = this.getSocketPort(i);
            }
            return port < start ? dflt : port;
        }
        return this.parseInt(portProp, dflt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSocketPort(int i) {
        int port = -1;
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(i);
            port = ss.getLocalPort();
        }
        catch (IOException e) {
            SystemLogger.debug("Unable to bind to port: " + i);
        }
        finally {
            this.closeSilently(ss);
        }
        return port;
    }

    private Object getProperty(String name) {
        String value;
        Dictionary<String, ?> conf = this.config;
        String string = value = conf != null ? (String)conf.get(name) : null;
        if (value == null) {
            value = this.context.getProperty(name);
        }
        return value;
    }

    private String[] getStringArrayProperty(String name, String[] defValue) {
        Object value = this.getProperty(name);
        if (value instanceof String) {
            String stringVal = ((String)value).trim();
            if (stringVal.length() > 0) {
                return stringVal.split(",");
            }
        } else if (value instanceof String[]) {
            String[] stringArr = (String[])value;
            ArrayList<String> list = new ArrayList<String>();
            for (String stringVal : stringArr) {
                if (stringVal.trim().length() <= 0) continue;
                list.add(stringVal.trim());
            }
            if (list.size() > 0) {
                return list.toArray(new String[list.size()]);
            }
        } else if (value instanceof Collection) {
            ArrayList<String> conv = new ArrayList<String>();
            for (Object object : (Collection)value) {
                if (object == null) continue;
                conv.add(String.valueOf(object));
            }
            if (conv.size() > 0) {
                return conv.toArray(new String[conv.size()]);
            }
        }
        return defValue;
    }

    private int parseInt(String value, int dflt) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    private long parseLong(String value, long dflt) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }
}

