/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.fileinstall.internal.Artifact;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.fileinstall.internal.WatcherScanner;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;

public class DirectoryWatcher
extends Thread
implements BundleListener {
    public static final String FILENAME = "felix.fileinstall.filename";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String LOG_LEVEL = "felix.fileinstall.log.level";
    public static final String LOG_DEFAULT = "felix.fileinstall.log.default";
    public static final String TMPDIR = "felix.fileinstall.tmpdir";
    public static final String FILTER = "felix.fileinstall.filter";
    public static final String START_NEW_BUNDLES = "felix.fileinstall.bundles.new.start";
    public static final String USE_START_TRANSIENT = "felix.fileinstall.bundles.startTransient";
    public static final String USE_START_ACTIVATION_POLICY = "felix.fileinstall.bundles.startActivationPolicy";
    public static final String NO_INITIAL_DELAY = "felix.fileinstall.noInitialDelay";
    public static final String DISABLE_CONFIG_SAVE = "felix.fileinstall.disableConfigSave";
    public static final String ENABLE_CONFIG_SAVE = "felix.fileinstall.enableConfigSave";
    public static final String START_LEVEL = "felix.fileinstall.start.level";
    public static final String ACTIVE_LEVEL = "felix.fileinstall.active.level";
    public static final String UPDATE_WITH_LISTENERS = "felix.fileinstall.bundles.updateWithListeners";
    public static final String OPTIONAL_SCOPE = "felix.fileinstall.optionalImportRefreshScope";
    public static final String FRAGMENT_SCOPE = "felix.fileinstall.fragmentRefreshScope";
    public static final String DISABLE_NIO2 = "felix.fileinstall.disableNio2";
    public static final String SUBDIR_MODE = "felix.fileinstall.subdir.mode";
    public static final String SCOPE_NONE = "none";
    public static final String SCOPE_MANAGED = "managed";
    public static final String SCOPE_ALL = "all";
    public static final String LOG_STDOUT = "stdout";
    public static final String LOG_JUL = "jul";
    final FileInstall fileInstall;
    Map<String, String> properties;
    File watchedDirectory;
    File tmpDir;
    long poll;
    int logLevel;
    boolean startBundles;
    boolean useStartTransient;
    boolean useStartActivationPolicy;
    String filter;
    BundleContext context;
    private Bundle systemBundle;
    String originatingFileName;
    boolean noInitialDelay;
    int startLevel;
    int activeLevel;
    boolean updateWithListeners;
    String fragmentScope;
    String optionalScope;
    boolean disableNio2;
    final Map<File, Artifact> currentManagedArtifacts = new HashMap<File, Artifact>();
    Scanner scanner;
    final Set<File> processingFailures = new HashSet<File>();
    Set<Bundle> delayedStart = new HashSet<Bundle>();
    Set<Bundle> consistentlyFailingBundles = new HashSet<Bundle>();
    final Map<File, Artifact> installationFailures = new HashMap<File, Artifact>();
    private AtomicBoolean stateChanged = new AtomicBoolean();

    public DirectoryWatcher(FileInstall fileInstall, Map<String, String> properties, BundleContext context) {
        super("fileinstall-" + DirectoryWatcher.getThreadName(properties));
        this.fileInstall = fileInstall;
        this.properties = properties;
        this.context = context;
        this.systemBundle = context.getBundle("System Bundle");
        this.poll = this.getLong(properties, POLL, 2000L);
        this.logLevel = this.getInt(properties, LOG_LEVEL, Util.getGlobalLogLevel(context));
        this.originatingFileName = properties.get(FILENAME);
        this.watchedDirectory = this.getFile(properties, DIR, new File("./load"));
        this.verifyWatchedDir();
        this.tmpDir = this.getFile(properties, TMPDIR, null);
        this.prepareTempDir();
        this.startBundles = this.getBoolean(properties, START_NEW_BUNDLES, true);
        this.useStartTransient = this.getBoolean(properties, USE_START_TRANSIENT, false);
        this.useStartActivationPolicy = this.getBoolean(properties, USE_START_ACTIVATION_POLICY, true);
        this.filter = properties.get(FILTER);
        this.noInitialDelay = this.getBoolean(properties, NO_INITIAL_DELAY, false);
        this.startLevel = this.getInt(properties, START_LEVEL, 0);
        this.activeLevel = this.getInt(properties, ACTIVE_LEVEL, 0);
        this.updateWithListeners = this.getBoolean(properties, UPDATE_WITH_LISTENERS, false);
        this.fragmentScope = properties.get(FRAGMENT_SCOPE);
        this.optionalScope = properties.get(OPTIONAL_SCOPE);
        this.disableNio2 = this.getBoolean(properties, DISABLE_NIO2, false);
        this.context.addBundleListener((BundleListener)this);
        if (this.disableNio2) {
            this.scanner = new Scanner(this.watchedDirectory, this.filter, properties.get(SUBDIR_MODE));
        } else {
            try {
                this.scanner = new WatcherScanner(context, this.watchedDirectory, this.filter, properties.get(SUBDIR_MODE));
            }
            catch (Throwable t) {
                this.scanner = new Scanner(this.watchedDirectory, this.filter, properties.get(SUBDIR_MODE));
            }
        }
    }

    private void verifyWatchedDir() {
        if (!this.watchedDirectory.exists()) {
            this.log(2, this.watchedDirectory + " does not exist, please create it.", null);
        } else if (!this.watchedDirectory.isDirectory()) {
            this.log(1, "Cannot use " + this.watchedDirectory + " because it's not a directory", null);
            throw new RuntimeException("File Install can't monitor " + this.watchedDirectory + " because it is not a directory");
        }
    }

    public static String getThreadName(Map<String, String> properties) {
        return properties.get(DIR) != null ? properties.get(DIR) : "./load";
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void start() {
        if (this.noInitialDelay) {
            this.log(4, "Starting initial scan", null);
            this.initializeCurrentManagedBundles();
            Set<File> files = this.scanner.scan(true);
            if (files != null) {
                try {
                    this.process(files);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            try {
                this.fileInstall.lock.readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log(3, "Watcher for " + this.watchedDirectory + " exiting because of interruption.", e);
                return;
            }
            try {
                this.log(4, "{felix.fileinstall.poll (ms) = " + this.poll + ", " + DIR + " = " + this.watchedDirectory.getAbsolutePath() + ", " + LOG_LEVEL + " = " + this.logLevel + ", " + START_NEW_BUNDLES + " = " + this.startBundles + ", " + TMPDIR + " = " + this.tmpDir + ", " + FILTER + " = " + this.filter + ", " + START_LEVEL + " = " + this.startLevel + "}", null);
                if (this.noInitialDelay) break block18;
                try {
                    Thread.sleep(this.poll);
                }
                catch (InterruptedException e) {
                    this.log(4, "Watcher for " + this.watchedDirectory + " was interrupted while waiting " + this.poll + " milliseconds for initial directory scan.", e);
                    this.fileInstall.lock.readLock().unlock();
                    return;
                }
                this.initializeCurrentManagedBundles();
            }
            finally {
                this.fileInstall.lock.readLock().unlock();
            }
        }
        while (!DirectoryWatcher.interrupted()) {
            try {
                Object files;
                FrameworkStartLevel startLevelSvc = (FrameworkStartLevel)this.systemBundle.adapt(FrameworkStartLevel.class);
                if (startLevelSvc.getStartLevel() >= this.activeLevel && this.systemBundle.getState() == 32 && (files = this.scanner.scan(false)) != null) {
                    this.process((Set<File>)files);
                }
                files = this;
                synchronized (files) {
                    this.wait(this.poll);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                return;
            }
            catch (Throwable e) {
                try {
                    this.context.getBundle();
                }
                catch (IllegalStateException t) {
                    return;
                }
                this.log(1, "In main loop, we have serious trouble", e);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        int type = bundleEvent.getType();
        if (type == 16) {
            Iterator<Artifact> it = this.getArtifacts().iterator();
            while (it.hasNext()) {
                Artifact artifact = it.next();
                if (artifact.getBundleId() != bundleEvent.getBundle().getBundleId()) continue;
                this.log(4, "Bundle " + bundleEvent.getBundle().getBundleId() + " has been uninstalled", null);
                it.remove();
                break;
            }
        }
        if (type == 1 || type == 32 || type == 16 || type == 64 || type == 8) {
            this.setStateChanged(true);
        }
    }

    private void process(Set<File> files) throws InterruptedException {
        this.fileInstall.lock.readLock().lockInterruptibly();
        try {
            this.doProcess(files);
        }
        finally {
            this.fileInstall.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Set<File> files) throws InterruptedException {
        List<ArtifactListener> listeners = this.fileInstall.getListeners();
        ArrayList<Artifact> deleted = new ArrayList<Artifact>();
        ArrayList<Artifact> modified = new ArrayList<Artifact>();
        ArrayList<Artifact> created = new ArrayList<Artifact>();
        Set<File> set = this.processingFailures;
        synchronized (set) {
            files.addAll(this.processingFailures);
            this.processingFailures.clear();
        }
        for (File file : files) {
            Set<File> set2;
            ArtifactListener listener;
            boolean exists = file.exists();
            Artifact artifact = this.getArtifact(file);
            if (!exists) {
                if (artifact == null) continue;
                this.deleteJaredDirectory(artifact);
                this.deleteTransformedFile(artifact);
                deleted.add(artifact);
                continue;
            }
            File jar = file;
            URL jaredUrl = null;
            try {
                jaredUrl = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (file.isDirectory()) {
                this.prepareTempDir();
                try {
                    jar = new File(this.tmpDir, file.getName() + ".jar");
                    Util.jarDir(file, jar);
                    jaredUrl = new URL("jardir", null, file.getPath());
                }
                catch (IOException e) {
                    this.log(1, "Unable to create jar for: " + file.getAbsolutePath(), e);
                    continue;
                }
            }
            if (artifact != null) {
                artifact.setChecksum(this.scanner.getChecksum(file));
                if (artifact.getListener() == null) {
                    listener = this.findListener(jar, listeners);
                    if (listener == null) {
                        set2 = this.processingFailures;
                        synchronized (set2) {
                            this.processingFailures.add(file);
                            continue;
                        }
                    }
                    artifact.setListener(listener);
                }
                if (!listeners.contains(artifact.getListener()) || !artifact.getListener().canHandle(jar)) {
                    deleted.add(artifact);
                    continue;
                }
                this.deleteTransformedFile(artifact);
                artifact.setJaredDirectory(jar);
                artifact.setJaredUrl(jaredUrl);
                if (this.transformArtifact(artifact)) {
                    modified.add(artifact);
                    continue;
                }
                this.deleteJaredDirectory(artifact);
                deleted.add(artifact);
                continue;
            }
            listener = this.findListener(jar, listeners);
            if (listener == null) {
                set2 = this.processingFailures;
                synchronized (set2) {
                    this.processingFailures.add(file);
                    continue;
                }
            }
            artifact = new Artifact();
            artifact.setPath(file);
            artifact.setJaredDirectory(jar);
            artifact.setJaredUrl(jaredUrl);
            artifact.setListener(listener);
            artifact.setChecksum(this.scanner.getChecksum(file));
            if (this.transformArtifact(artifact)) {
                created.add(artifact);
                continue;
            }
            this.deleteJaredDirectory(artifact);
        }
        Collection<Bundle> uninstalledBundles = this.uninstall(deleted);
        Collection<Bundle> updatedBundles = this.update(modified);
        Collection<Bundle> installedBundles = this.install(created);
        if (!(uninstalledBundles.isEmpty() && updatedBundles.isEmpty() && installedBundles.isEmpty())) {
            HashSet<Bundle> toRefresh = new HashSet<Bundle>();
            toRefresh.addAll(uninstalledBundles);
            toRefresh.addAll(updatedBundles);
            toRefresh.addAll(installedBundles);
            this.findBundlesWithFragmentsToRefresh(toRefresh);
            this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
            if (toRefresh.size() > 0) {
                this.refresh(toRefresh);
                this.setStateChanged(true);
            }
        }
        if (this.startBundles && this.isStateChanged()) {
            this.startAllBundles();
            this.delayedStart.addAll(installedBundles);
            this.delayedStart.removeAll(uninstalledBundles);
            this.startBundles(this.delayedStart);
            this.consistentlyFailingBundles.clear();
            this.consistentlyFailingBundles.addAll(this.delayedStart);
            this.setStateChanged(false);
        }
    }

    ArtifactListener findListener(File artifact, List<ArtifactListener> listeners) {
        for (ArtifactListener listener : listeners) {
            if (!listener.canHandle(artifact)) continue;
            return listener;
        }
        return null;
    }

    boolean transformArtifact(Artifact artifact) {
        if (artifact.getListener() instanceof ArtifactTransformer) {
            this.prepareTempDir();
            try {
                File transformed = ((ArtifactTransformer)artifact.getListener()).transform(artifact.getJaredDirectory(), this.tmpDir);
                if (transformed != null) {
                    artifact.setTransformed(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        if (artifact.getListener() instanceof ArtifactUrlTransformer) {
            try {
                URL url = artifact.getJaredUrl();
                URL transformed = ((ArtifactUrlTransformer)artifact.getListener()).transform(url);
                if (transformed != null) {
                    artifact.setTransformedUrl(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        return true;
    }

    private void deleteTransformedFile(Artifact artifact) {
        if (artifact.getTransformed() != null && !artifact.getTransformed().equals(artifact.getPath()) && !artifact.getTransformed().delete()) {
            this.log(2, "Unable to delete transformed artifact: " + artifact.getTransformed().getAbsolutePath(), null);
        }
    }

    private void deleteJaredDirectory(Artifact artifact) {
        if (artifact.getJaredDirectory() != null && !artifact.getJaredDirectory().equals(artifact.getPath()) && !artifact.getJaredDirectory().delete()) {
            this.log(2, "Unable to delete jared artifact: " + artifact.getJaredDirectory().getAbsolutePath(), null);
        }
    }

    private void prepareTempDir() {
        if (this.tmpDir == null) {
            File javaIoTmpdir = new File(System.getProperty("java.io.tmpdir"));
            if (!javaIoTmpdir.exists() && !javaIoTmpdir.mkdirs()) {
                throw new IllegalStateException("Unable to create temporary directory " + javaIoTmpdir);
            }
            Random random = new Random();
            while (this.tmpDir == null) {
                File f = new File(javaIoTmpdir, "fileinstall-" + Long.toString(random.nextLong()));
                if (f.exists() || !f.mkdirs()) continue;
                this.tmpDir = f;
                this.tmpDir.deleteOnExit();
            }
        } else {
            this.prepareDir(this.tmpDir);
        }
    }

    private void prepareDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            this.log(1, "Cannot create folder " + dir + ". Is the folder write-protected?", null);
            throw new RuntimeException("Cannot create folder: " + dir);
        }
        if (!dir.isDirectory()) {
            this.log(1, "Cannot use " + dir + " because it's not a directory", null);
            throw new RuntimeException("Cannot start FileInstall using something that is not a directory");
        }
    }

    void log(int msgLevel, String message, Throwable e) {
        Util.log(this.context, this.logLevel, msgLevel, message, e);
    }

    boolean isFragment(Bundle bundle) {
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (rev.getTypes() & 1) != 0;
    }

    void refresh(Collection<Bundle> bundles) throws InterruptedException {
        FileInstall.refresh(this.systemBundle, bundles);
    }

    int getInt(Map<String, String> properties, String property, int dflt) {
        String value = properties.get(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a int: " + value, null);
            }
        }
        return dflt;
    }

    long getLong(Map<String, String> properties, String property, long dflt) {
        String value = properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    File getFile(Map<String, String> properties, String property, File dflt) {
        String value = properties.get(property);
        if (value != null) {
            return new File(value);
        }
        return dflt;
    }

    boolean getBoolean(Map<String, String> properties, String property, boolean dflt) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return dflt;
    }

    public void close() {
        this.context.removeBundleListener((BundleListener)this);
        this.interrupt();
        for (Artifact artifact : this.getArtifacts()) {
            this.deleteTransformedFile(artifact);
            this.deleteJaredDirectory(artifact);
        }
        try {
            this.scanner.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.watchedDirectory.toURI().normalize().getPath();
        HashMap<File, Long> checksums = new HashMap<File, Long>();
        for (Bundle bundle : bundles) {
            int index;
            String location = bundle.getLocation();
            String path = null;
            if (location != null && !location.equals("System Bundle")) {
                URI uri;
                try {
                    uri = new URI(bundle.getLocation()).normalize();
                }
                catch (URISyntaxException e) {
                    uri = new File(location).toURI().normalize();
                }
                if (uri.isOpaque() && uri.getSchemeSpecificPart() != null) {
                    String schemeSpecificPart = uri.getSchemeSpecificPart();
                    int lastIndexOfFileProtocol = schemeSpecificPart.lastIndexOf("file:");
                    int offsetFileProtocol = lastIndexOfFileProtocol >= 0 ? lastIndexOfFileProtocol + "file:".length() : 0;
                    int firstIndexOfDollar = schemeSpecificPart.indexOf("$");
                    int endOfPath = firstIndexOfDollar >= 0 ? firstIndexOfDollar : schemeSpecificPart.length();
                    path = schemeSpecificPart.substring(offsetFileProtocol, endOfPath);
                } else {
                    path = uri.getPath();
                }
            }
            if (path == null || (index = path.lastIndexOf(47)) == -1 || !path.startsWith(watchedDirPath)) continue;
            Artifact artifact = new Artifact();
            artifact.setBundleId(bundle.getBundleId());
            artifact.setChecksum(Util.loadChecksum(bundle, this.context));
            artifact.setListener(null);
            artifact.setPath(new File(path));
            this.setArtifact(new File(path), artifact);
            checksums.put(new File(path), artifact.getChecksum());
        }
        this.scanner.initialize(checksums);
    }

    private Collection<Bundle> install(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this.install(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection<Bundle> uninstall(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this.uninstall(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection<Bundle> update(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this.update(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle install(Artifact artifact) {
        File path = artifact.getPath();
        Bundle bundle = null;
        AtomicBoolean modified = new AtomicBoolean();
        try {
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).install(path);
            } else if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                Artifact badArtifact = this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                URL transformed = artifact.getTransformedUrl();
                String location = transformed.toString();
                try (BufferedInputStream in = new BufferedInputStream(transformed.openStream());){
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum(), modified);
                }
                artifact.setBundleId(bundle.getBundleId());
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                Artifact badArtifact = this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                File transformed = artifact.getTransformed();
                String location = path.toURI().normalize().toString();
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(transformed != null ? transformed : path));){
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum(), modified);
                }
                artifact.setBundleId(bundle.getBundleId());
            }
            this.installationFailures.remove(path);
            this.setArtifact(path, artifact);
        }
        catch (Exception e) {
            this.log(1, "Failed to install artifact: " + path, e);
            this.installationFailures.put(path, artifact);
        }
        return modified.get() ? bundle : null;
    }

    private Bundle installOrUpdateBundle(String bundleLocation, BufferedInputStream is, long checksum, AtomicBoolean modified) throws IOException, BundleException {
        Bundle[] bundles;
        is.mark(262144);
        JarInputStream jar = new JarInputStream(is);
        Manifest m = jar.getManifest();
        if (m == null) {
            throw new BundleException("The bundle " + bundleLocation + " does not have a META-INF/MANIFEST.MF! " + "Make sure, META-INF and MANIFEST.MF are the first 2 entries in your JAR!");
        }
        String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
        String vStr = m.getMainAttributes().getValue("Bundle-Version");
        Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
        for (Bundle b : bundles = this.context.getBundles()) {
            Version bv;
            if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
            vStr = (String)b.getHeaders().get("Bundle-Version");
            Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            if (!v.equals((Object)bv)) continue;
            is.reset();
            if (Util.loadChecksum(b, this.context) != checksum) {
                this.log(2, "A bundle with the same symbolic name (" + sn + ") and version (" + vStr + ") is already installed.  Updating this bundle instead.", null);
                this.stopTransient(b);
                Util.storeChecksum(b, checksum, this.context);
                b.update((InputStream)is);
                modified.set(true);
            }
            return b;
        }
        is.reset();
        Util.log(this.context, 3, "Installing bundle " + sn + " / " + v, null);
        Bundle b = this.context.installBundle(bundleLocation, (InputStream)is);
        Util.storeChecksum(b, checksum, this.context);
        modified.set(true);
        if (this.startLevel != 0) {
            ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(this.startLevel);
        }
        return b;
    }

    private Bundle uninstall(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() == null) {
                artifact.setListener(this.findListener(path, this.fileInstall.getListeners()));
            }
            this.removeArtifact(path);
            this.deleteTransformedFile(artifact);
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).uninstall(path);
            } else if (artifact.getBundleId() != 0L) {
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log(2, "Failed to uninstall bundle: " + path + " with id: " + artifact.getBundleId() + ". The bundle has already been uninstalled", null);
                    return null;
                }
                this.log(3, "Uninstalling bundle " + bundle.getBundleId() + " (" + bundle.getSymbolicName() + ")", null);
                bundle.uninstall();
            }
        }
        catch (Exception e) {
            this.log(2, "Failed to uninstall artifact: " + artifact.getPath(), e);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle update(Artifact artifact) {
        Bundle bundle;
        block12: {
            bundle = null;
            try {
                File path = artifact.getPath();
                if (artifact.getListener() instanceof ArtifactInstaller) {
                    ((ArtifactInstaller)artifact.getListener()).update(path);
                    break block12;
                }
                if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                    URL transformed = artifact.getTransformedUrl();
                    bundle = this.context.getBundle(artifact.getBundleId());
                    if (bundle == null) {
                        this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                        return null;
                    }
                    Util.log(this.context, 3, "Updating bundle " + bundle.getSymbolicName() + " / " + bundle.getVersion(), null);
                    this.stopTransient(bundle);
                    Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                    try (InputStream in = transformed != null ? transformed.openStream() : new FileInputStream(path);){
                        bundle.update(in);
                        break block12;
                    }
                }
                if (!(artifact.getListener() instanceof ArtifactTransformer)) break block12;
                File transformed = artifact.getTransformed();
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                    return null;
                }
                Util.log(this.context, 3, "Updating bundle " + bundle.getSymbolicName() + " / " + bundle.getVersion(), null);
                this.stopTransient(bundle);
                Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                try (FileInputStream in = new FileInputStream(transformed != null ? transformed : path);){
                    bundle.update((InputStream)in);
                }
            }
            catch (Throwable t) {
                this.log(2, "Failed to update artifact " + artifact.getPath(), t);
            }
        }
        return bundle;
    }

    private void stopTransient(Bundle bundle) throws BundleException {
        if (this.startBundles && !this.isFragment(bundle)) {
            bundle.stop(1);
        }
    }

    private void startAllBundles() {
        FrameworkStartLevel startLevelSvc = (FrameworkStartLevel)this.systemBundle.adapt(FrameworkStartLevel.class);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : this.getArtifacts()) {
            Bundle bundle;
            if (artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getState() == 8 || bundle.getState() == 32 || !this.useStartTransient && !((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted() || startLevelSvc.getStartLevel() < ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel()) continue;
            bundles.add(bundle);
        }
        this.startBundles(bundles);
    }

    private void startBundles(Collection<Bundle> bundles) {
        boolean logFailures = bundles.equals(this.consistentlyFailingBundles);
        Iterator<Bundle> b = bundles.iterator();
        while (b.hasNext()) {
            if (!this.startBundle(b.next(), logFailures)) continue;
            b.remove();
        }
    }

    private boolean startBundle(Bundle bundle, boolean logFailures) {
        block3: {
            FrameworkStartLevel startLevelSvc = (FrameworkStartLevel)this.systemBundle.adapt(FrameworkStartLevel.class);
            if (this.startBundles && bundle.getState() != 1 && !this.isFragment(bundle) && startLevelSvc.getStartLevel() >= ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel()) {
                try {
                    int options = this.useStartTransient ? 1 : 0;
                    bundle.start(options |= this.useStartActivationPolicy ? 2 : 0);
                    this.log(3, "Started bundle: " + bundle.getLocation(), null);
                    return true;
                }
                catch (BundleException e) {
                    if (!logFailures) break block3;
                    this.log(2, "Error while starting bundle: " + bundle.getLocation(), e);
                }
            }
        }
        return false;
    }

    protected Set<Bundle> getScopedBundles(String scope) {
        if (SCOPE_NONE.equals(scope)) {
            return new HashSet<Bundle>();
        }
        if (SCOPE_MANAGED.equals(scope)) {
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (Artifact artifact : this.getArtifacts()) {
                Bundle bundle;
                if (artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null) continue;
                bundles.add(bundle);
            }
            return bundles;
        }
        return new HashSet<Bundle>(Arrays.asList(this.context.getBundles()));
    }

    protected void findBundlesWithFragmentsToRefresh(Set<Bundle> toRefresh) {
        HashSet<Bundle> fragments = new HashSet<Bundle>();
        Set<Bundle> bundles = this.getScopedBundles(this.fragmentScope);
        for (Bundle b : toRefresh) {
            Clause[] clauses;
            String hostHeader;
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            for (Bundle hostBundle : bundles) {
                if (hostBundle.getSymbolicName() == null || !hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(VersionTable.getVersion((String)hostBundle.getHeaders().get("Bundle-Version")))) continue;
                    fragments.add(hostBundle);
                    continue;
                }
                fragments.add(hostBundle);
            }
        }
        toRefresh.addAll(fragments);
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        List importsList;
        Set<Bundle> bundles = this.getScopedBundles(this.optionalScope);
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Object, List> imports = new HashMap<Object, List>();
        Iterator<Bundle> it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : toRefresh) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator<Bundle> it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause anImport : imports) {
            String resolution = anImport.getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(anImport);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ArtifactListener listener, long stamp) {
        if (this.updateWithListeners) {
            for (Artifact artifact : this.getArtifacts()) {
                File path;
                Bundle bundle;
                if (artifact.getListener() != null || artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getLastModified() >= stamp || !listener.canHandle(path = artifact.getPath())) continue;
                Set<File> set = this.processingFailures;
                synchronized (set) {
                    this.processingFailures.add(path);
                }
            }
        }
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ArtifactListener listener) {
        for (Artifact artifact : this.getArtifacts()) {
            if (artifact.getListener() != listener) continue;
            artifact.setListener(null);
        }
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact getArtifact(File file) {
        Map<File, Artifact> map = this.currentManagedArtifacts;
        synchronized (map) {
            return this.currentManagedArtifacts.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Artifact> getArtifacts() {
        Map<File, Artifact> map = this.currentManagedArtifacts;
        synchronized (map) {
            return new ArrayList<Artifact>(this.currentManagedArtifacts.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setArtifact(File file, Artifact artifact) {
        Map<File, Artifact> map = this.currentManagedArtifacts;
        synchronized (map) {
            this.currentManagedArtifacts.put(file, artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArtifact(File file) {
        Map<File, Artifact> map = this.currentManagedArtifacts;
        synchronized (map) {
            this.currentManagedArtifacts.remove(file);
        }
    }

    private void setStateChanged(boolean changed) {
        this.stateChanged.set(changed);
    }

    private boolean isStateChanged() {
        return this.stateChanged.get();
    }
}

