/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.fileinstall.internal.Watcher;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatcherScanner
extends Scanner {
    BundleContext bundleContext;
    PathMatcher fileMatcher;
    Watcher watcher;
    Set<File> changed = new HashSet<File>();

    public WatcherScanner(BundleContext bundleContext, File directory, String filterString) throws IOException {
        super(directory, filterString);
        this.bundleContext = bundleContext;
        this.fileMatcher = filterString != null ? FileSystems.getDefault().getPathMatcher("regex:" + filterString) : null;
        this.watcher = new ScannerWatcher();
        this.watcher.setFileMatcher(this.fileMatcher);
        this.watcher.setRootDirectory(this.directory);
        this.watcher.init();
        this.watcher.rescan();
    }

    @Override
    public Set<File> scan(boolean reportImmediately) {
        this.watcher.processEvents();
        if (this.changed.isEmpty()) {
            return new HashSet<File>();
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<Object> removed = new HashSet<Object>();
        if (reportImmediately) {
            removed.addAll(this.storedChecksums.keySet());
        }
        for (File file : this.changed) {
            long lastChecksum = this.lastChecksums.get(file) != null ? (Long)this.lastChecksums.get(file) : 0L;
            long storedChecksum = this.storedChecksums.get(file) != null ? (Long)this.storedChecksums.get(file) : 0L;
            long newChecksum = WatcherScanner.checksum(file);
            this.lastChecksums.put(file, newChecksum);
            if (file.exists()) {
                if (newChecksum != lastChecksum && !reportImmediately) continue;
                if (newChecksum != storedChecksum) {
                    this.storedChecksums.put(file, newChecksum);
                    files.add(file);
                } else {
                    this.changed.remove(file);
                }
                if (!reportImmediately) continue;
                removed.remove(file);
                continue;
            }
            if (reportImmediately) continue;
            removed.add(file);
        }
        for (File file : removed) {
            files.addAll(removed);
            this.lastChecksums.remove(file);
            this.storedChecksums.remove(file);
        }
        for (File file : files) {
            this.changed.remove(file);
        }
        return files;
    }

    @Override
    public void close() throws IOException {
        this.watcher.close();
    }

    class ScannerWatcher
    extends Watcher {
        ScannerWatcher() {
        }

        protected void process(Path path) {
            File file = path.toFile();
            while (!file.getParentFile().equals(WatcherScanner.this.directory)) {
                if ((file = file.getParentFile()) != null) continue;
                return;
            }
            WatcherScanner.this.changed.add(file);
        }

        protected void onRemove(Path path) {
            File file = path.toFile();
            while (!file.getParentFile().equals(WatcherScanner.this.directory)) {
                if ((file = file.getParentFile()) != null) continue;
                return;
            }
            WatcherScanner.this.changed.add(file);
        }

        protected void debug(String message, Object ... args) {
            this.log(4, message, args);
        }

        protected void warn(String message, Object ... args) {
            this.log(2, message, args);
        }

        protected void log(int level, String message, Object ... args) {
            String msg = String.format(message, args);
            Util.log(WatcherScanner.this.bundleContext, level, msg, null);
        }
    }
}

