/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigInstaller
implements ArtifactInstaller,
ConfigurationListener {
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private final FileInstall fileInstall;
    private ServiceRegistration registration;

    ConfigInstaller(BundleContext context, ConfigurationAdmin configAdmin, FileInstall fileInstall) {
        this.context = context;
        this.configAdmin = configAdmin;
        this.fileInstall = fileInstall;
    }

    public void init() {
        this.registration = this.context.registerService(new String[]{ConfigurationListener.class.getName(), ArtifactListener.class.getName(), ArtifactInstaller.class.getName()}, (Object)this, null);
    }

    public void destroy() {
        this.registration.unregister();
    }

    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".cfg") || artifact.getName().endsWith(".config");
    }

    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent configurationEvent) {
        block12: {
            if (!this.shouldSaveConfig()) {
                return;
            }
            if (configurationEvent.getType() == 1) {
                try {
                    File file;
                    Configuration config = this.getConfigurationAdmin().getConfiguration(configurationEvent.getPid(), configurationEvent.getFactoryPid());
                    Dictionary dict = config.getProperties();
                    String fileName = (String)dict.get("felix.fileinstall.filename");
                    File file2 = file = fileName != null ? this.fromConfigKey(fileName) : null;
                    if (file == null || !file.isFile()) break block12;
                    if (fileName.endsWith(".cfg")) {
                        org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file, this.context);
                        Enumeration e = dict.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                            String val = dict.get(key).toString();
                            props.put(key, val);
                        }
                        props.save();
                    } else if (fileName.endsWith(".config")) {
                        FileOutputStream fos = new FileOutputStream(file);
                        Properties props = new Properties();
                        Enumeration e = dict.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                            props.put(key, dict.get(key));
                        }
                        try {
                            ConfigurationHandler.write(fos, props);
                        }
                        finally {
                            ((OutputStream)fos).close();
                        }
                    }
                    this.fileInstall.updateChecksum(file);
                }
                catch (Exception e) {
                    Util.log(this.context, 3, "Unable to save configuration", e);
                }
            }
        }
    }

    boolean shouldSaveConfig() {
        String str = this.context.getProperty("felix.fileinstall.enableConfigSave");
        if (str == null) {
            str = this.context.getProperty("felix.fileinstall.disableConfigSave");
        }
        if (str != null) {
            return Boolean.valueOf(str);
        }
        return true;
    }

    ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setConfig(File f) throws Exception {
        Hashtable old;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        try {
            if (f.getName().endsWith(".cfg")) {
                Properties p = new Properties();
                ((InputStream)in).mark(1);
                boolean isXml = ((InputStream)in).read() == 60;
                ((InputStream)in).reset();
                if (isXml) {
                    p.loadFromXML(in);
                } else {
                    p.load(in);
                }
                HashMap<String, String> strMap = new HashMap<String, String>();
                for (Object k : p.keySet()) {
                    strMap.put(k.toString(), p.getProperty(k.toString()));
                }
                InterpolationHelper.performSubstitution(strMap, this.context);
                ht.putAll(strMap);
            } else if (f.getName().endsWith(".config")) {
                Dictionary config = ConfigurationHandler.read(in);
                Enumeration i = config.keys();
                while (i.hasMoreElements()) {
                    Object key = i.nextElement();
                    ht.put(key.toString(), (String)config.get(key));
                }
            }
        }
        finally {
            ((InputStream)in).close();
        }
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        Dictionary props = config.getProperties();
        Hashtable hashtable = old = props != null ? new Hashtable(new DictionaryAsMap(props)) : null;
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (!ht.equals(old)) {
            ht.put("felix.fileinstall.filename", this.toConfigKey(f));
            if (config.getBundleLocation() != null) {
                config.setBundleLocation(null);
            }
            if (old == null) {
                Util.log(this.context, 3, "Creating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
            } else {
                Util.log(this.context, 3, "Updating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
            }
            config.update(ht);
            return true;
        }
        return false;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Util.log(this.context, 3, "Deleting configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        config.delete();
        return true;
    }

    String toConfigKey(File f) {
        return f.getAbsoluteFile().toURI().toString();
    }

    File fromConfigKey(String key) {
        return new File(URI.create(key));
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String fileName, String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(fileName);
        if (oldConfiguration != null) {
            return oldConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigurationAdmin().createFactoryConfiguration(pid, null) : this.getConfigurationAdmin().getConfiguration(pid, null);
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String fileName) throws Exception {
        String filter = "(felix.fileinstall.filename=" + this.escapeFilterValue(fileName) + ")";
        Configuration[] configurations = this.getConfigurationAdmin().listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private String escapeFilterValue(String s) {
        return s.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)").replaceAll("[=]", "\\\\=").replaceAll("[\\*]", "\\\\*");
    }
}

