/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import aQute.bnd.version.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.felix.bundleplugin.baseline.AbstractBaselinePlugin;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

@Mojo(name="baseline", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VERIFY)
public final class BaselinePlugin
extends AbstractBaselinePlugin {
    private static final String TABLE_PATTERN = "%s %-50s %-10s %-10s %-10s %-10s %-10s";
    @Parameter(defaultValue="${project.build.directory}/baseline.xml")
    private File xmlOutputFile;
    @Parameter(defaultValue="true", property="logResults")
    private boolean logResults;

    @Override
    protected Object init(Object noContext) {
        if (this.xmlOutputFile != null) {
            this.xmlOutputFile.getParentFile().mkdirs();
            try {
                Context ctx = new Context();
                ctx.writer = new FileWriter(this.xmlOutputFile);
                ctx.xmlWriter = new PrettyPrintXMLWriter((Writer)ctx.writer);
                return ctx;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("No XML report will be produced, cannot write data to " + this.xmlOutputFile), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected void close(Object writer) {
        if (writer != null) {
            try {
                ((Context)writer).writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void startBaseline(Object context, String generationDate, String bundleName, String currentVersion, String previousVersion) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (this.isLoggingResults()) {
            this.log("Baseline Report - Generated by Apache Felix Maven Bundle Plugin on %s based on Bnd - see http://www.aqute.biz/Bnd/Bnd", generationDate);
            this.log("Comparing bundle %s version %s to version %s", bundleName, currentVersion, previousVersion);
            this.log("", new Object[0]);
            this.log(TABLE_PATTERN, " ", "PACKAGE_NAME", "DELTA", "CUR_VER", "BASE_VER", "REC_VER", "WARNINGS", "ATTRIBUTES");
            this.log(TABLE_PATTERN, "=", "==================================================", "==========", "==========", "==========", "==========", "==========", "==========");
        }
        if (xmlWriter != null) {
            xmlWriter.startElement("baseline");
            xmlWriter.addAttribute("version", "1.0.0");
            xmlWriter.addAttribute("vendor", "The Apache Software Foundation");
            xmlWriter.addAttribute("vendorURL", "http://www.apache.org/");
            xmlWriter.addAttribute("generator", "Apache Felix Maven Bundle Plugin");
            xmlWriter.addAttribute("generatorURL", "http://felix.apache.org/site/apache-felix-maven-bundle-plugin-bnd.html");
            xmlWriter.addAttribute("analyzer", "Bnd");
            xmlWriter.addAttribute("analyzerURL", "http://www.aqute.biz/Bnd/Bnd");
            xmlWriter.addAttribute("generatedOn", generationDate);
            xmlWriter.addAttribute("bundleName", bundleName);
            xmlWriter.addAttribute("currentVersion", currentVersion);
            xmlWriter.addAttribute("previousVersion", previousVersion);
        }
    }

    @Override
    protected void startPackage(Object context, boolean mismatch, String name, String shortDelta, String delta, Version newerVersion, Version olderVersion, Version suggestedVersion, DiffMessage diffMessage, Map<String, String> attributes) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (this.isLoggingResults()) {
            this.log(TABLE_PATTERN, mismatch ? Character.valueOf('*') : shortDelta, name, delta, newerVersion, olderVersion, suggestedVersion, diffMessage != null ? diffMessage : Character.valueOf('-'), attributes);
        }
        if (xmlWriter != null) {
            xmlWriter.startElement("package");
            xmlWriter.addAttribute("name", name);
            xmlWriter.addAttribute("delta", delta);
            this.simpleElement(xmlWriter, "mismatch", String.valueOf(mismatch));
            this.simpleElement(xmlWriter, "newerVersion", newerVersion.toString());
            this.simpleElement(xmlWriter, "olderVersion", olderVersion.toString());
            if (suggestedVersion != null) {
                this.simpleElement(xmlWriter, "suggestedVersion", suggestedVersion.toString());
            }
            if (diffMessage != null) {
                this.simpleElement(xmlWriter, diffMessage.getType().name(), diffMessage.getMessage());
            }
            xmlWriter.startElement("attributes");
            if (attributes != null) {
                for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                    String attributeName = attribute.getKey();
                    if (':' == attributeName.charAt(attributeName.length() - 1)) {
                        attributeName = attributeName.substring(0, attributeName.length() - 1);
                    }
                    String attributeValue = attribute.getValue();
                    xmlWriter.startElement(attributeName);
                    xmlWriter.writeText(attributeValue);
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
        }
    }

    @Override
    protected void startDiff(Object context, int depth, String type, String name, String delta, String shortDelta) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (this.isLoggingResults()) {
            this.log("%-" + depth * 4 + "s %s %s %s", "", shortDelta, type, name);
        }
        if (xmlWriter != null) {
            xmlWriter.startElement(type);
            xmlWriter.addAttribute("name", name);
            xmlWriter.addAttribute("delta", delta);
        }
    }

    @Override
    protected void endDiff(Object context, int depth) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (xmlWriter != null) {
            xmlWriter.endElement();
        }
    }

    @Override
    protected void endPackage(Object context) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (this.isLoggingResults()) {
            this.log("-----------------------------------------------------------------------------------------------------------", new Object[0]);
        }
        if (xmlWriter != null) {
            xmlWriter.endElement();
        }
    }

    @Override
    protected void endBaseline(Object context) {
        XMLWriter xmlWriter;
        XMLWriter xMLWriter = xmlWriter = context == null ? null : ((Context)context).xmlWriter;
        if (xmlWriter != null) {
            xmlWriter.endElement();
        }
    }

    private boolean isLoggingResults() {
        return this.logResults && this.getLog().isInfoEnabled();
    }

    private void log(String format, Object ... args) {
        this.getLog().info((CharSequence)String.format(format, args));
    }

    private void simpleElement(XMLWriter xmlWriter, String name, String value) {
        xmlWriter.startElement(name);
        xmlWriter.writeText(value);
        xmlWriter.endElement();
    }

    private static final class Context {
        public FileWriter writer;
        public XMLWriter xmlWriter;

        private Context() {
        }
    }
}

