/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.collections.ExtList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.ManifestWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ManifestPlugin
extends BundlePlugin {
    @Parameter(property="rebuildBundle")
    protected boolean rebuildBundle;
    @Parameter(property="supportIncrementalBuild")
    private boolean supportIncrementalBuild;
    @Component
    private BuildContext buildContext;

    @Override
    protected void execute(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Analyzer analyzer;
        if (!(!this.buildContext.isIncremental() || this.supportIncrementalBuild && this.anyJavaSourceFileTouchedSinceLastBuild())) {
            this.getLog().debug((CharSequence)"Skipping manifest generation because no java source file was added, updated or removed since last build.");
            return;
        }
        try {
            analyzer = this.getAnalyzer(project, dependencyGraph, instructions, properties, classpath);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot find " + e.getMessage() + " (manifest goal must be run after compile phase)", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", (Exception)e);
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in manifest configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
        File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
        try {
            ManifestPlugin.writeManifest(analyzer, outputFile, this.niceManifest, this.exportScr, this.scrLocation, this.buildContext, this.getLog());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, e);
        }
        finally {
            try {
                analyzer.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, (Exception)e);
            }
        }
    }

    private boolean anyJavaSourceFileTouchedSinceLastBuild() {
        List sourceDirectories = this.project.getCompileSourceRoots();
        for (String sourceDirectory : sourceDirectories) {
            File directory = new File(sourceDirectory);
            Scanner scanner = this.buildContext.newScanner(directory);
            Scanner deleteScanner = this.buildContext.newDeleteScanner(directory);
            if (!this.containsJavaFile(scanner) && !this.containsJavaFile(deleteScanner)) continue;
            return true;
        }
        return false;
    }

    private boolean containsJavaFile(Scanner scanner) {
        String[] includes = new String[]{"**/*.java"};
        scanner.setIncludes(includes);
        scanner.scan();
        return scanner.getIncludedFiles().length > 0;
    }

    public Manifest getManifest(MavenProject project, DependencyNode dependencyGraph, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        return this.getManifest(project, dependencyGraph, new LinkedHashMap<String, String>(), new Properties(), classpath, this.buildContext);
    }

    public Manifest getManifest(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath, BuildContext buildContext) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        Analyzer analyzer = this.getAnalyzer(project, dependencyGraph, instructions, properties, classpath);
        Jar jar = analyzer.getJar();
        Manifest manifest = jar.getManifest();
        if (this.exportScr) {
            ManifestPlugin.exportScr(analyzer, jar, this.scrLocation, buildContext, this.getLog());
        }
        analyzer.close();
        return manifest;
    }

    private static void exportScr(Analyzer analyzer, Jar jar, File scrLocation, BuildContext buildContext, Log log) throws Exception {
        Map metatypeDir;
        log.debug((CharSequence)("Export SCR metadata to: " + scrLocation.getPath()));
        scrLocation.mkdirs();
        Map scrDir = (Map)jar.getDirectories().get("OSGI-INF");
        if (scrDir != null) {
            for (Map.Entry entry : scrDir.entrySet()) {
                String path = (String)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                ManifestPlugin.writeSCR(resource, new File(scrLocation, path), buildContext, log);
            }
        }
        if ((metatypeDir = (Map)jar.getDirectories().get("OSGI-INF/metatype")) != null) {
            for (Map.Entry entry : metatypeDir.entrySet()) {
                String path = (String)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                ManifestPlugin.writeSCR(resource, new File(scrLocation, path), buildContext, log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSCR(Resource resource, File destination, BuildContext buildContext, Log log) throws Exception {
        log.debug((CharSequence)("Write SCR file: " + destination.getPath()));
        destination.getParentFile().mkdirs();
        try (OutputStream os = buildContext.newFileOutputStream(destination);){
            resource.write(os);
        }
    }

    protected Analyzer getAnalyzer(MavenProject project, DependencyNode dependencyGraph, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        return this.getAnalyzer(project, dependencyGraph, new LinkedHashMap<String, String>(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        String failok;
        if (this.rebuildBundle && this.supportedProjectTypes.contains(project.getArtifact().getType())) {
            return this.buildOSGiBundle(project, dependencyGraph, instructions, properties, classpath);
        }
        File file = this.getOutputDirectory();
        if (file == null) {
            file = project.getArtifact().getFile();
        }
        if (!file.exists()) {
            if (file.equals(this.getOutputDirectory())) {
                file.mkdirs();
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        Builder analyzer = this.getOSGiBuilder(project, instructions, properties, classpath);
        analyzer.setJar(file);
        boolean isOutputDirectory = file.equals(this.getOutputDirectory());
        if (analyzer.getProperty("Export-Package") == null && analyzer.getProperty("-exportcontents") == null && analyzer.getProperty("Private-Package") == null && !isOutputDirectory) {
            String export = ManifestPlugin.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        this.addMavenInstructions(project, dependencyGraph, analyzer);
        if (analyzer.getProperty("Embed-Dependency") != null && isOutputDirectory) {
            analyzer.build();
        } else {
            analyzer.mergeManifest(analyzer.getJar().getManifest());
            analyzer.getJar().setManifest(analyzer.calcManifest());
        }
        this.mergeMavenManifest(project, dependencyGraph, analyzer);
        boolean hasErrors = this.reportErrors("Manifest " + project.getArtifact(), (Analyzer)analyzer);
        if (hasErrors && (null == (failok = analyzer.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
            throw new MojoFailureException("Error(s) found in manifest configuration");
        }
        Jar jar = analyzer.getJar();
        if (this.unpackBundle) {
            File outputFile = this.getOutputDirectory();
            for (Map.Entry entry : jar.getResources().entrySet()) {
                File entryFile = new File(outputFile, (String)entry.getKey());
                if (entryFile.exists() && ((Resource)entry.getValue()).lastModified() != 0L) continue;
                entryFile.getParentFile().mkdirs();
                OutputStream os = this.buildContext.newFileOutputStream(entryFile);
                ((Resource)entry.getValue()).write(os);
                os.close();
            }
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Analyzer analyzer, File outputFile, boolean niceManifest, boolean exportScr, File scrLocation, BuildContext buildContext, Log log) throws Exception {
        Properties properties = analyzer.getProperties();
        Jar jar = analyzer.getJar();
        Manifest manifest = jar.getManifest();
        if (outputFile.exists() && properties.containsKey("Merge-Headers")) {
            Manifest analyzerManifest = manifest;
            manifest = new Manifest();
            try (FileInputStream inputStream = new FileInputStream(outputFile);){
                manifest.read(inputStream);
            }
            Instructions instructions = new Instructions((Collection)ExtList.from((String)analyzer.getProperty("Merge-Headers")));
            ManifestPlugin.mergeManifest(instructions, manifest, analyzerManifest);
        } else {
            File parentFile = outputFile.getParentFile();
            parentFile.mkdirs();
        }
        ManifestPlugin.writeManifest(manifest, outputFile, niceManifest, buildContext, log);
        if (exportScr) {
            ManifestPlugin.exportScr(analyzer, jar, scrLocation, buildContext, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Manifest manifest, File outputFile, boolean niceManifest, BuildContext buildContext, Log log) throws IOException {
        log.debug((CharSequence)("Write manifest to " + outputFile.getPath()));
        outputFile.getParentFile().mkdirs();
        OutputStream os = buildContext.newFileOutputStream(outputFile);
        try {
            ManifestWriter.outputManifest(manifest, os, niceManifest);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map map = bundle.getDirectories();
        for (Map.Entry entry : map.entrySet()) {
            String directory;
            if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty() || (directory = (String)entry.getKey()).equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }
}

