/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.osgi;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.osgi.ManifestReadingException;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class DefaultMaven2OsgiConverter
implements Maven2OsgiConverter {
    private static final Pattern OSGI_VERSION_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+(\\.[0-9A-Za-z_-]+)?");
    private static final Pattern ONLY_NUMBERS = Pattern.compile("[0-9]+");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    private String getBundleSymbolicName(String groupId, String artifactId) {
        return groupId + "." + artifactId;
    }

    public String getBundleSymbolicName(Artifact artifact) {
        String groupIdFromPackage;
        int i;
        if (artifact.getFile() != null && artifact.getFile().isFile()) {
            Analyzer analyzer = new Analyzer();
            JarFile jar = null;
            try {
                String symbolicNameAttribute;
                Map bundleSymbolicNameHeader;
                Iterator it;
                jar = new JarFile(artifact.getFile(), false);
                if (jar.getManifest() != null && (it = (bundleSymbolicNameHeader = analyzer.parseHeader(symbolicNameAttribute = jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName"))).keySet().iterator()).hasNext()) {
                    String string = (String)it.next();
                    return string;
                }
            }
            catch (IOException e) {
                throw new ManifestReadingException("Error reading manifest in jar " + artifact.getFile().getAbsolutePath(), e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if ((i = artifact.getGroupId().lastIndexOf(46)) < 0 && artifact.getFile() != null && artifact.getFile().isFile() && (groupIdFromPackage = this.getGroupIdFromPackage(artifact.getFile())) != null) {
            return groupIdFromPackage;
        }
        String lastSection = artifact.getGroupId().substring(++i);
        if (artifact.getArtifactId().equals(lastSection)) {
            return artifact.getGroupId();
        }
        if (artifact.getArtifactId().startsWith(lastSection)) {
            String artifactId = artifact.getArtifactId().substring(lastSection.length());
            if (Character.isLetterOrDigit(artifactId.charAt(0))) {
                return this.getBundleSymbolicName(artifact.getGroupId(), artifactId);
            }
            return this.getBundleSymbolicName(artifact.getGroupId(), artifactId.substring(1));
        }
        return this.getBundleSymbolicName(artifact.getGroupId(), artifact.getArtifactId());
    }

    private String getGroupIdFromPackage(File artifactFile) {
        try {
            HashSet<String> packageNames = new HashSet<String>();
            JarFile jar = new JarFile(artifactFile, false);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                File f;
                String packageName;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || (packageName = (f = new File(entry.getName())).getParent()) == null) continue;
                packageNames.add(packageName);
            }
            jar.close();
            String[] groupIdSections = null;
            for (String packageName : packageNames) {
                int i;
                String[] packageNameSections = packageName.split("\\" + FILE_SEPARATOR);
                if (groupIdSections == null) {
                    groupIdSections = packageNameSections;
                    continue;
                }
                for (i = 0; i < packageNameSections.length && i < groupIdSections.length && packageNameSections[i].equals(groupIdSections[i]); ++i) {
                }
                groupIdSections = new String[i];
                System.arraycopy(packageNameSections, 0, groupIdSections, 0, i);
            }
            if (groupIdSections == null || groupIdSections.length == 0) {
                return null;
            }
            if (groupIdSections.length == 1) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < groupIdSections.length; ++i) {
                sb.append(groupIdSections[i]);
                if (i >= groupIdSections.length - 1) continue;
                sb.append('.');
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBundleFileName(Artifact artifact) {
        return this.getBundleSymbolicName(artifact) + "_" + this.getVersion(artifact.getVersion()) + ".jar";
    }

    public String getVersion(Artifact artifact) {
        return this.getVersion(artifact.getVersion());
    }

    public String getVersion(String version) {
        String qualifier;
        String service;
        String minor;
        String major;
        Pattern NEED_TO_FILL_ZEROS;
        Matcher m = OSGI_VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return version;
        }
        String osgiVersion = version;
        Pattern DATED_SNAPSHOT = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9]))?\\-([0-9]{8}\\.[0-9]{6}\\-[0-9]*)");
        m = DATED_SNAPSHOT.matcher(osgiVersion);
        if (m.matches()) {
            String major2 = m.group(1);
            String minor2 = m.group(3) != null ? m.group(3) : "0";
            String service2 = m.group(5) != null ? m.group(5) : "0";
            String qualifier2 = m.group(6).replaceAll("-", "_").replaceAll("\\.", "_");
            osgiVersion = major2 + "." + minor2 + "." + service2 + "." + qualifier2;
        }
        osgiVersion = osgiVersion.replaceFirst("-", "\\.");
        m = OSGI_VERSION_PATTERN.matcher(osgiVersion = osgiVersion.replaceAll("-", "_"));
        if (m.matches()) {
            return osgiVersion;
        }
        Pattern DOTS_IN_QUALIFIER = Pattern.compile("([0-9])(\\.[0-9])?\\.([0-9A-Za-z_-]+)\\.([0-9A-Za-z_-]+)");
        m = DOTS_IN_QUALIFIER.matcher(osgiVersion);
        if (m.matches()) {
            String s1 = m.group(1);
            String s2 = m.group(2);
            String s3 = m.group(3);
            String s4 = m.group(4);
            Matcher qualifierMatcher = ONLY_NUMBERS.matcher(s3);
            if (!qualifierMatcher.matches()) {
                osgiVersion = s1 + s2 + "." + s3 + "_" + s4;
            }
        }
        if ((m = (NEED_TO_FILL_ZEROS = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9A-Za-z_-]+))?")).matcher(osgiVersion)).matches()) {
            major = m.group(1);
            minor = m.group(3);
            service = null;
            qualifier = m.group(5);
            if (qualifier == null) {
                osgiVersion = this.getVersion(major, minor, service, qualifier);
            } else {
                Matcher qualifierMatcher = ONLY_NUMBERS.matcher(qualifier);
                if (qualifierMatcher.matches()) {
                    if (minor == null) {
                        minor = qualifier;
                    } else {
                        service = qualifier;
                    }
                    osgiVersion = this.getVersion(major, minor, service, null);
                } else {
                    osgiVersion = this.getVersion(major, minor, service, qualifier);
                }
            }
        }
        if (!(m = OSGI_VERSION_PATTERN.matcher(osgiVersion)).matches()) {
            major = "0";
            minor = "0";
            service = "0";
            qualifier = osgiVersion.replaceAll("\\.", "_");
            osgiVersion = major + "." + minor + "." + service + "." + qualifier;
        }
        return osgiVersion;
    }

    private String getVersion(String major, String minor, String service, String qualifier) {
        StringBuffer sb = new StringBuffer();
        sb.append(major != null ? major : "0");
        sb.append('.');
        sb.append(minor != null ? minor : "0");
        sb.append('.');
        sb.append(service != null ? service : "0");
        if (qualifier != null) {
            sb.append('.');
            sb.append(qualifier);
        }
        return sb.toString();
    }
}

