/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class BundleInfo {
    private Map exportedPackages = new HashMap();

    public void addExportedPackage(String packageName, Artifact artifact) {
        HashSet<Artifact> artifacts = (HashSet<Artifact>)this.getExportedPackages().get(packageName);
        if (artifacts == null) {
            artifacts = new HashSet<Artifact>();
            this.exportedPackages.put(packageName, artifacts);
        }
        artifacts.add(artifact);
    }

    Map getExportedPackages() {
        return this.exportedPackages;
    }

    public Map getDuplicatedExports() {
        HashMap<String, Set> duplicatedExports = new HashMap<String, Set>();
        Iterator it = this.getExportedPackages().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set artifacts = (Set)entry.getValue();
            if (artifacts.size() <= 1) continue;
            HashSet<String> artifactKeys = new HashSet<String>();
            String packageName = (String)entry.getKey();
            Iterator it2 = artifacts.iterator();
            while (it2.hasNext()) {
                Artifact artifact = (Artifact)it2.next();
                artifactKeys.add(artifact.getGroupId() + "." + artifact.getArtifactId());
            }
            if (artifactKeys.size() <= 1) continue;
            duplicatedExports.put(packageName, artifacts);
        }
        return duplicatedExports;
    }

    public void merge(BundleInfo bundleInfo) {
        Iterator it = bundleInfo.getExportedPackages().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String packageName = (String)entry.getKey();
            Collection artifacts = (Collection)entry.getValue();
            HashSet artifactsWithPackage = (HashSet)this.getExportedPackages().get(packageName);
            if (artifactsWithPackage == null) {
                artifactsWithPackage = new HashSet();
                this.getExportedPackages().put(packageName, artifactsWithPackage);
            }
            artifactsWithPackage.addAll(artifacts);
        }
    }
}

