/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.bnd;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import aQute.libg.reporter.Reporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Handler;
import org.apache.felix.ipojo.bnd.ByteArrayResource;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.manipulator.render.MetadataRenderer;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.util.Streams;
import org.apache.felix.ipojo.metadata.Element;

public class BndJarResourceStore
implements ResourceStore {
    private Analyzer m_analyzer;
    private Reporter m_reporter;
    private MetadataRenderer m_renderer = new MetadataRenderer();
    private List<Element> m_metadata = new ArrayList<Element>();

    public BndJarResourceStore(Analyzer analyzer, Reporter reporter) {
        this.m_analyzer = analyzer;
        this.m_reporter = reporter;
    }

    public byte[] read(String path) throws IOException {
        Resource resource = this.m_analyzer.getJar().getResource(path);
        InputStream is = null;
        try {
            is = resource.openInputStream();
        }
        catch (Exception e) {
            throw new IOException("Cannot read " + path);
        }
        return Streams.readBytes((InputStream)is);
    }

    public void accept(ResourceVisitor visitor) {
        try {
            String annotations = Component.class.getName() + "|" + Handler.class.getName();
            Collection classes = this.m_analyzer.getClasses(new String[]{"", Clazz.QUERY.ANNOTATION.name(), annotations, Clazz.QUERY.NAMED.name(), "*"});
            for (Clazz clazz : classes) {
                visitor.visit(clazz.getPath());
            }
        }
        catch (Exception e) {
            this.m_reporter.error("Cannot find iPOJO annotated types: " + e.getMessage(), new Object[0]);
        }
    }

    public void open() throws IOException {
    }

    public void writeMetadata(Element metadata) {
        this.m_metadata.add(metadata);
        for (String referred : Metadatas.findReferredPackages((Element)metadata)) {
            if (this.m_analyzer.getReferred().get(referred) != null) continue;
            this.m_analyzer.getReferred().put(referred, new HashMap());
        }
    }

    public void write(String resourcePath, byte[] resource) throws IOException {
        Jar jar = this.m_analyzer.getJar();
        jar.putResource(resourcePath, (Resource)new ByteArrayResource(resource));
    }

    public void close() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Element metadata : this.m_metadata) {
            builder.append(this.m_renderer.render(metadata));
        }
        if (builder.length() != 0) {
            this.m_analyzer.setProperty("IPOJO-Components", builder.toString());
        }
        TreeMap<String, String> version = new TreeMap<String, String>();
        version.put("version", " 1.8.0");
        if (this.m_analyzer.getReferred().get("org.apache.felix.ipojo") == null) {
            this.m_analyzer.getReferred().put("org.apache.felix.ipojo", version);
        }
        if (this.m_analyzer.getReferred().get("org.apache.felix.ipojo.architecture") == null) {
            this.m_analyzer.getReferred().put("org.apache.felix.ipojo.architecture", version);
        }
        if (this.m_analyzer.getReferred().get("org.osgi.service.cm") == null) {
            TreeMap<String, String> cm = new TreeMap<String, String>();
            cm.put("version", "1.2");
            this.m_analyzer.getReferred().put("org.osgi.service.cm", cm);
        }
        if (this.m_analyzer.getReferred().get("org.osgi.service.log") == null) {
            TreeMap<String, String> log = new TreeMap<String, String>();
            log.put("version", "1.3");
            this.m_analyzer.getReferred().put("org.osgi.service.log", log);
        }
    }
}

