/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.exceptions.EmpireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyGetException
extends EmpireException {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertyGetException.class);
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.propertyGetError", "Unable to get the property {0} from type {1}.");

    public BeanPropertyGetException(Object bean, String property, Throwable cause) {
        super(errorType, new String[]{property, bean != null ? bean.getClass().getName() : "{unknown}"}, cause);
    }

    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

