/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.sqlserver;

import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.sqlserver.DBDatabaseDriverMSSQL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSqlDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverMSSQL> {
    public MSSqlDDLGenerator(DBDatabaseDriverMSSQL driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_CHAR = "NCHAR";
        this.DATATYPE_VARCHAR = "NVARCHAR";
        this.DATATYPE_DATE = "DATETIME";
        this.DATATYPE_TIMESTAMP = "DATETIME";
        this.DATATYPE_CLOB = "NTEXT";
        this.DATATYPE_BLOB = "IMAGE";
        this.DATATYPE_UNIQUEID = "UNIQUEID";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBDatabaseDriverMSSQL)this.driver).isUseSequenceTable()) break;
                int minValue = ObjectUtils.getInteger(c.getAttribute("minValue"), 1);
                sql.append(" IDENTITY(");
                sql.append(String.valueOf(minValue));
                sql.append(", 1) NOT NULL");
                return false;
            }
            case TEXT: 
            case CHAR: {
                if (type == DataType.CHAR) {
                    sql.append(c.isSingleByteChars() ? this.DATATYPE_CHAR.substring(1) : this.DATATYPE_CHAR);
                } else {
                    sql.append(c.isSingleByteChars() ? this.DATATYPE_VARCHAR.substring(1) : this.DATATYPE_VARCHAR);
                }
                int len = Math.abs((int)size);
                if (len == 0) {
                    len = type == DataType.CHAR ? 1 : 100;
                }
                sql.append("(");
                sql.append(String.valueOf(len));
                sql.append(")");
                break;
            }
            case UNIQUEID: {
                sql.append(this.DATATYPE_UNIQUEID);
                if (!c.isAutoGenerated()) break;
                sql.append(" ROWGUIDCOL");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        String databaseName = ((DBDatabaseDriverMSSQL)this.driver).getDatabaseName();
        if (StringUtils.isNotEmpty(databaseName)) {
            script.addStmt("USE master");
            script.addStmt("IF NOT EXISTS(SELECT * FROM sysdatabases WHERE name = '" + databaseName + "') CREATE DATABASE " + databaseName);
            script.addStmt("USE " + databaseName);
            script.addStmt("SET DATEFORMAT ymd");
            if (((DBDatabaseDriverMSSQL)this.driver).isUseSequenceTable() && db.getTable(((DBDatabaseDriverMSSQL)this.driver).getSequenceTableName()) == null) {
                new DBDatabaseDriver.DBSeqTable(((DBDatabaseDriverMSSQL)this.driver).getSequenceTableName(), db);
            }
        }
        super.createDatabase(db, script);
    }
}

