/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.oracle;

import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.oracle.OracleRowNumExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;

public class DBCommandOracle
extends DBCommand {
    private static final long serialVersionUID = 1L;
    protected DBCompareExpr connectBy = null;
    protected DBCompareExpr startWith = null;
    protected String optimizerHint = null;
    protected OracleRowNumExpr rowNumExpr = null;

    public DBCommandOracle(DBDatabase db) {
        super(db);
    }

    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public void setOptimizerIndexHint(DBIndex index) {
        if (index == null || index.getTable() == null) {
            throw new InvalidArgumentException("index", index);
        }
        String tableAlias = index.getTable().getAlias();
        String indexName = index.getName();
        this.optimizerHint = "INDEX (" + tableAlias + " " + indexName + ")";
    }

    public void clear() {
        super.clear();
        this.clearConnectBy();
        this.optimizerHint = null;
    }

    public void clearConnectBy() {
        this.startWith = null;
        this.connectBy = null;
    }

    public void connectByPrior(DBCompareExpr expr) {
        this.connectBy = expr;
    }

    public void startWith(DBCompareExpr expr) {
        this.startWith = expr;
    }

    public void limitRows(int numRows) {
        if (this.rowNumExpr == null) {
            this.rowNumExpr = new OracleRowNumExpr(this.getDatabase());
        }
        this.where(this.rowNumExpr.isLessOrEqual(numRows));
    }

    public void clearLimit() {
        if (this.rowNumExpr != null) {
            this.removeWhereConstraintOn(this.rowNumExpr);
        }
        this.rowNumExpr = null;
    }

    public synchronized void getSelect(StringBuilder buf) {
        this.resetParamUsage();
        if (this.select == null) {
            throw new ObjectNotValidException(this);
        }
        buf.append("SELECT ");
        if (this.optimizerHint != null) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        if (this.selectDistinct) {
            buf.append("DISTINCT ");
        }
        this.addListExpr(buf, this.select, 15L, ", ");
        this.addFrom(buf);
        this.addWhere(buf);
        if (this.connectBy != null) {
            buf.append("\r\nCONNECT BY PRIOR ");
            this.connectBy.addSQL(buf, 23L);
            if (this.startWith != null) {
                buf.append("\r\nSTART WITH ");
                this.startWith.addSQL(buf, 7L);
            }
        }
        this.addGrouping(buf);
        if (this.orderBy != null) {
            if (this.connectBy != null) {
                buf.append("\r\nORDER SIBLINGS BY ");
            } else {
                buf.append("\r\nORDER BY ");
            }
            this.addListExpr(buf, this.orderBy, 7L, ", ");
        }
    }

    public synchronized String getDelete(DBTable table) {
        this.resetParamUsage();
        StringBuilder buf = new StringBuilder("DELETE ");
        if (this.optimizerHint != null) {
            buf.append("/*+ ").append(this.optimizerHint).append(" */ ");
        }
        buf.append("FROM ");
        table.addSQL(buf, 2L);
        if (this.where != null || this.having != null) {
            buf.append("\r\nWHERE ");
            if (this.where != null) {
                this.addListExpr(buf, this.where, 5L, " AND ");
            }
        }
        return buf.toString();
    }
}

