/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import java.util.HashSet;
import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.compare.DBCompareExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBJoinExpr
extends DBExpr {
    private static final long serialVersionUID = 1L;
    protected DBColumnExpr left;
    protected DBColumnExpr right;
    protected DBJoinType type;
    public DBCompareExpr compExpr = null;

    public DBJoinExpr(DBColumnExpr left, DBColumnExpr right, DBJoinType type) {
        this.left = left;
        this.right = right;
        this.type = type;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    public DBColumnExpr getLeft() {
        return this.left;
    }

    public DBColumnExpr getRight() {
        return this.right;
    }

    public DBJoinType getType() {
        return this.type;
    }

    public boolean isJoinOn(DBRowSet rowset) {
        if (rowset == null) {
            return false;
        }
        DBColumn l = this.left != null ? this.left.getUpdateColumn() : null;
        DBColumn r = this.right != null ? this.right.getUpdateColumn() : null;
        DBRowSet rsl = l != null ? l.getRowSet() : null;
        DBRowSet rsr = r != null ? r.getRowSet() : null;
        return rowset.equals(rsl) || rowset.equals(rsr);
    }

    public boolean isJoinOn(DBColumn column) {
        if (column == null) {
            return false;
        }
        if (column.equals(this.left.getUpdateColumn()) || column.equals(this.right.getUpdateColumn())) {
            return true;
        }
        if (this.compExpr != null) {
            HashSet<DBColumn> set = new HashSet<DBColumn>();
            this.compExpr.addReferencedColumns(set);
            return set.contains(column);
        }
        return false;
    }

    public DBRowSet getOuterTable() {
        switch (this.type) {
            case LEFT: {
                return this.right.getUpdateColumn().getRowSet();
            }
            case RIGHT: {
                return this.left.getUpdateColumn().getRowSet();
            }
        }
        return null;
    }

    public void reverse() {
        DBColumnExpr swap = this.left;
        this.left = this.right;
        this.right = swap;
        this.type = DBJoinType.reversed(this.type);
    }

    public void where(DBCompareExpr expr) {
        this.compExpr = expr;
    }

    public DBCompareExpr and(DBColumnExpr c1, DBColumnExpr c2) {
        this.compExpr = c1.is(c2);
        return this.compExpr;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        this.right.addReferencedColumns(list);
        if (this.compExpr != null) {
            this.compExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L) != 0L) {
            this.left.getUpdateColumn().getRowSet().addSQL(buf, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    buf.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    buf.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    buf.append(" RIGHT JOIN ");
                    break;
                }
                default: {
                    buf.append(" JOIN ");
                }
            }
            this.right.getUpdateColumn().getRowSet().addSQL(buf, 15L);
            buf.append(" ON ");
            this.right.addSQL(buf, 7L);
            buf.append(" = ");
            this.left.addSQL(buf, 7L);
            if (this.compExpr != null) {
                buf.append(" AND ");
                this.compExpr.addSQL(buf, 7L);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return super.equals(obj);
        }
        DBJoinExpr other = (DBJoinExpr)obj;
        if (this.left.equals(other.left) && this.right.equals(other.right) && this.type == other.type) {
            return true;
        }
        return this.left.equals(other.right) && this.right.equals(other.left) && this.type == DBJoinType.reversed(other.type);
    }
}

